/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.event.impl;

import java.security.Principal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.event.CoreEvent;

public class CoreEventImpl
implements CoreEvent {
    protected final String eventId;
    protected final Object source;
    protected final Map<String, Object> info;
    protected final Date date = new Date();
    protected final Principal principal;
    protected final String category;
    protected final String comment;
    public static final String COMMENT_ATTRIBUTE = "comment";
    public static final String CATEGORY_ATTRIBUTE = "category";

    public CoreEventImpl(String eventId, Object source, Map<String, ?> info, Principal principal, String category, String comment) {
        this.eventId = eventId != null ? eventId.intern() : null;
        this.source = source;
        this.info = info == null ? new HashMap<String, Object>() : new HashMap(info);
        this.principal = principal;
        if (!this.info.containsKey(COMMENT_ATTRIBUTE)) {
            this.info.put(COMMENT_ATTRIBUTE, comment);
        }
        if (!this.info.containsKey(CATEGORY_ATTRIBUTE)) {
            this.info.put(CATEGORY_ATTRIBUTE, category);
        }
        this.comment = comment;
        this.category = category;
    }

    public boolean isComposite() {
        return false;
    }

    public List<CoreEvent> getNestedEvents() {
        return null;
    }

    @Override
    public String getEventId() {
        return this.eventId;
    }

    @Override
    public Map<String, ?> getInfo() {
        return this.info;
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    @Override
    public String getCategory() {
        if (this.category != null) {
            return this.category;
        }
        Object categoryObj = this.info.get(CATEGORY_ATTRIBUTE);
        if (categoryObj instanceof String) {
            return (String)categoryObj;
        }
        return null;
    }

    @Override
    public String getComment() {
        if (this.comment != null) {
            return this.comment;
        }
        Object commentObj = this.info.get(COMMENT_ATTRIBUTE);
        if (commentObj instanceof String) {
            return (String)commentObj;
        }
        return null;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public Principal getPrincipal() {
        return this.principal;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CoreEventImpl.class.getSimpleName());
        sb.append(" {");
        sb.append(" eventId: ");
        sb.append(this.eventId);
        sb.append(", source: ");
        sb.append(this.source);
        sb.append(", info: ");
        sb.append(this.info);
        sb.append(", date: ");
        sb.append(this.date);
        sb.append(", principal name: ");
        if (this.principal != null) {
            sb.append(this.principal.getName());
        }
        sb.append(", comment: ");
        sb.append(this.getComment());
        sb.append(", category: ");
        sb.append(this.getCategory());
        sb.append('}');
        return sb.toString();
    }
}

