/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.model.DocumentPart;
import org.nuxeo.ecm.core.api.model.PropertyConversionException;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.api.model.PropertyVisitor;
import org.nuxeo.ecm.core.api.model.resolver.PropertyObjectResolver;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.Type;

public interface Property
extends Cloneable,
Serializable,
Iterable<Property> {
    public static final int NONE = 0;
    public static final int IS_NEW = 1;
    public static final int IS_MODIFIED = 2;
    public static final int IS_REMOVED = 4;
    public static final int IS_MOVED = 8;
    public static final int IS_PHANTOM = 16;
    public static final int IS_DIRTY = 15;
    public static final int DIRTY_MASK = 31;

    public boolean isNew();

    public boolean isRemoved();

    public boolean isModified();

    public boolean isMoved();

    public boolean isPhantom();

    public boolean isDirty();

    public boolean isForceDirty();

    public void setForceDirty(boolean var1);

    public int getDirtyFlags();

    public void clearDirtyFlags();

    public boolean isReadOnly();

    public void setReadOnly(boolean var1);

    public boolean isSecured();

    public boolean isComplex();

    public boolean isList();

    public boolean isScalar();

    public boolean isContainer();

    public boolean hasDefaultValue();

    public String getName();

    public String getXPath();

    @Deprecated
    public String getPath();

    public Type getType();

    public Field getField();

    public Property getParent();

    public Schema getSchema();

    public DocumentPart getRoot();

    public void init(Serializable var1) throws PropertyException;

    public void setValue(Object var1) throws PropertyException;

    public Serializable getValue() throws PropertyException;

    public Serializable getValueForWrite() throws PropertyException;

    public <T> T getValue(Class<T> var1) throws PropertyException;

    public Serializable remove() throws PropertyException;

    public Property get(String var1) throws PropertyNotFoundException;

    public Property get(int var1) throws PropertyNotFoundException;

    public void set(String var1, Property var2) throws PropertyException;

    public void setValue(int var1, Object var2) throws PropertyException;

    public Collection<Property> getChildren();

    public int size();

    public Property addValue(Object var1) throws PropertyException;

    public Property addValue(int var1, Object var2) throws PropertyException;

    public Property addEmpty() throws PropertyException;

    public void moveTo(int var1);

    public Property resolvePath(String var1) throws PropertyNotFoundException;

    public Property resolvePath(Path var1) throws PropertyNotFoundException;

    public Serializable getValue(String var1) throws PropertyException;

    public <T> T getValue(Class<T> var1, String var2) throws PropertyException;

    public void setValue(String var1, Object var2) throws PropertyException;

    public Serializable normalize(Object var1) throws PropertyConversionException;

    public boolean isNormalized(Object var1);

    public <T> T convertTo(Serializable var1, Class<T> var2) throws PropertyConversionException;

    public boolean validateType(Class<?> var1);

    public Object newInstance();

    public void accept(PropertyVisitor var1, Object var2) throws PropertyException;

    public boolean isSameAs(Property var1) throws PropertyException;

    public Iterator<Property> getDirtyChildren();

    public PropertyObjectResolver getObjectResolver();
}

