/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.model.impl.primitives;

import java.io.Serializable;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyConversionException;
import org.nuxeo.ecm.core.api.model.impl.ScalarProperty;
import org.nuxeo.ecm.core.schema.types.Field;

public class BooleanProperty
extends ScalarProperty {
    private static final long serialVersionUID = -6408890276716577303L;

    public BooleanProperty(Property parent, Field field, int flags) {
        super(parent, field, flags);
    }

    @Override
    public boolean isNormalized(Object value) {
        return value == null || value.getClass() == Boolean.class;
    }

    @Override
    public Serializable normalize(Object value) throws PropertyConversionException {
        if (this.isNormalized(value)) {
            return (Serializable)value;
        }
        if (value.getClass() == String.class) {
            String string = (String)value;
            if (string.length() == 0) {
                return null;
            }
            return Boolean.valueOf(value.toString());
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        throw new PropertyConversionException(value.getClass(), Boolean.class);
    }

    @Override
    public <T> T convertTo(Serializable value, Class<T> toType) throws PropertyConversionException {
        if (value == null || Boolean.class == toType) {
            return (T)value;
        }
        Boolean v = (Boolean)value;
        if (toType == String.class) {
            return (T)v.toString();
        }
        byte n = (byte)(v != false ? 1 : 0);
        if (toType == Integer.class) {
            return (T)Integer.valueOf(n);
        }
        if (toType == Long.class) {
            return (T)Long.valueOf(n);
        }
        if (toType == Double.class) {
            return (T)Double.valueOf(n);
        }
        if (toType == Float.class) {
            return (T)Float.valueOf(n);
        }
        if (toType == Short.class) {
            return (T)Short.valueOf(n);
        }
        if (toType == Byte.class) {
            return (T)Byte.valueOf(n);
        }
        throw new PropertyConversionException(value.getClass(), toType);
    }

    @Override
    public Object newInstance() {
        return Boolean.FALSE;
    }
}

