/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.validation;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.validation.ConstraintViolation;
import org.nuxeo.ecm.core.api.validation.DocumentValidationReport;
import org.nuxeo.ecm.core.api.validation.GlobalViolation;
import org.nuxeo.ecm.core.api.validation.ValidationViolation;

public class DocumentValidationException
extends NuxeoException {
    protected static final String MESSAGE_SINGLE = "Constraint violation thrown%s: '%s'";
    protected static final String MESSAGE = "%s constraint violation(s) thrown. First one thrown%s: '%s', call " + DocumentValidationException.class.getSimpleName() + ".getViolations() to get the others";
    private static final long serialVersionUID = 1L;
    private DocumentValidationReport report;

    public DocumentValidationException(DocumentValidationReport report) {
        super(422);
        this.report = report;
    }

    public DocumentValidationException(String message) {
        super(message, 422);
        ArrayList<ValidationViolation> violations = new ArrayList<ValidationViolation>();
        violations.add(new GlobalViolation(message));
        this.report = new DocumentValidationReport(violations);
    }

    public DocumentValidationReport getReport() {
        return this.report;
    }

    @Override
    public String getMessage() {
        if (this.report.hasError()) {
            int num = this.report.numberOfErrors();
            ValidationViolation violation = this.report.asList().get(0);
            String xpath = "";
            if (violation instanceof ConstraintViolation) {
                ConstraintViolation cv = (ConstraintViolation)violation;
                xpath = cv.getPathAsString();
            }
            String propertyMessage = StringUtils.isBlank((CharSequence)xpath) ? "" : String.format(" on property %s", xpath);
            String violationMessage = violation.getMessage(null);
            if (num > 1) {
                return String.format(MESSAGE, this.report.numberOfErrors(), propertyMessage, violationMessage);
            }
            return String.format(MESSAGE_SINGLE, propertyMessage, violationMessage);
        }
        return super.getMessage();
    }
}

