/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.NuxeoException;

public abstract class PathStrategy {
    private static final Logger log = LogManager.getLogger(PathStrategy.class);
    protected final Path dir;
    protected static final Pattern SAFE = Pattern.compile("[ -~&&[^%/:\\\\]]+");
    protected static final char[] HEX = "0123456789abcdef".toCharArray();

    public PathStrategy(Path dir) {
        this.dir = dir.normalize();
    }

    protected String safePath(String key) {
        if (SAFE.matcher(key).matches() && !key.equals(".") && !key.equals("..")) {
            return key;
        }
        StringBuilder sb = new StringBuilder();
        sb.append('%');
        for (byte b : key.getBytes(StandardCharsets.UTF_8)) {
            if (b >= 32 && b <= 126 && b != 37 && b != 47 && b != 58 && b != 92) {
                sb.append((char)b);
                continue;
            }
            sb.append('%');
            sb.append(HEX[(0xF0 & b) >>> 4]);
            sb.append(HEX[0xF & b]);
        }
        return sb.toString();
    }

    protected String safePathInverse(String path) {
        if (!path.startsWith("%")) {
            return path;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        char[] chars = path.toCharArray();
        for (int i = 1; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '%') {
                if (i + 3 > chars.length) {
                    return null;
                }
                try {
                    c = (char)Integer.parseInt(path.substring(i + 1, i + 3), 16);
                    i += 2;
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            out.write(c);
        }
        return out.toString(StandardCharsets.UTF_8);
    }

    public Path createTempFile() {
        try {
            return Files.createTempFile(this.dir, "bin_", ".tmp", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new NuxeoException(e);
        }
    }

    public boolean isTempFile(Path path) {
        String filename = path.getFileName().toString();
        return filename.startsWith("bin_") && filename.endsWith(".tmp");
    }

    public abstract Path getPathForKey(String var1);

    public String getKeyForPath(String path) {
        path = path.substring(path.lastIndexOf("/") + 1);
        return this.safePathInverse(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void atomicMove(Path source, Path dest) throws IOException {
        try {
            Files.move(source, dest, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (AtomicMoveNotSupportedException amnse) {
            log.debug("Unoptimized atomic move from " + source + " to " + dest);
            Path tmp = Files.createTempFile(dest.getParent(), "bin_", ".tmp", new FileAttribute[0]);
            try {
                Files.copy(source, tmp, StandardCopyOption.REPLACE_EXISTING);
                Files.move(tmp, dest, StandardCopyOption.ATOMIC_MOVE);
                Files.delete(source);
            }
            finally {
                try {
                    Files.deleteIfExists(tmp);
                }
                catch (IOException e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void atomicCopy(Path source, Path dest) throws IOException {
        Path tmp = Files.createTempFile(dest.getParent(), "bin_", ".tmp", new FileAttribute[0]);
        try {
            Files.copy(source, tmp, StandardCopyOption.REPLACE_EXISTING);
            Files.move(tmp, dest, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            try {
                Files.deleteIfExists(tmp);
            }
            catch (IOException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }
}

