/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob.binary;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.common.file.FileCache;
import org.nuxeo.common.file.LRUFileCache;
import org.nuxeo.common.utils.SizeUtils;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.blob.binary.AbstractBinaryManager;
import org.nuxeo.ecm.core.blob.binary.Binary;
import org.nuxeo.ecm.core.blob.binary.BinaryManagerRootDescriptor;
import org.nuxeo.ecm.core.blob.binary.FileStorage;
import org.nuxeo.ecm.core.blob.binary.LazyBinary;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.trackers.files.FileEventTracker;

public abstract class CachingBinaryManager
extends AbstractBinaryManager {
    private static final Logger log = LogManager.getLogger(CachingBinaryManager.class);
    protected File cachedir;
    public FileCache fileCache;
    protected FileStorage fileStorage;

    @Override
    public void initialize(String blobProviderId, Map<String, String> properties) throws IOException {
        super.initialize(blobProviderId, properties);
        BinaryManagerRootDescriptor descriptor = new BinaryManagerRootDescriptor();
        descriptor.digest = this.getDefaultDigestAlgorithm();
        this.setDescriptor(descriptor);
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = blobProviderId::toString;
        supplierArray[1] = () -> this.getClass().getSimpleName();
        log.info("Registering binary manager '{}' using {}", supplierArray);
    }

    protected void initializeCache(File dir, long maxSize, long maxCount, long minAge, FileStorage fileStorage) {
        this.fileCache = new LRUFileCache(dir, maxSize, maxCount, minAge);
        this.fileStorage = fileStorage;
    }

    public void initializeCache(String maxSizeStr, FileStorage fileStorage) throws IOException {
        String maxCountStr = "10000";
        String minAgeStr = "3600";
        this.initializeCache(maxSizeStr, maxCountStr, minAgeStr, fileStorage);
    }

    public void initializeCache(String maxSizeStr, String maxCountStr, String minAgeStr, FileStorage fileStorage) throws IOException {
        this.cachedir = Framework.createTempFile((String)"nxbincache.", (String)"");
        this.cachedir.delete();
        this.cachedir.mkdir();
        long maxSize = SizeUtils.parseSizeInBytes((String)maxSizeStr);
        long maxCount = Long.parseLong(maxCountStr);
        long minAge = Long.parseLong(minAgeStr);
        this.initializeCache(this.cachedir, maxSize, maxCount, minAge, fileStorage);
        Supplier[] supplierArray = new Supplier[4];
        supplierArray[0] = this.cachedir::getPath;
        supplierArray[1] = maxSizeStr::toString;
        supplierArray[2] = () -> maxCount;
        supplierArray[3] = () -> minAge;
        log.info("Using binary cache directory: {} size: {} maxCount: {} minAge: {}", supplierArray);
        FileEventTracker.registerProtectedPath((String)this.cachedir.getAbsolutePath());
    }

    @Override
    public void close() {
        this.fileCache.clear();
        if (this.cachedir != null) {
            try {
                FileUtils.deleteDirectory((File)this.cachedir);
            }
            catch (IOException e) {
                throw new NuxeoException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Binary getBinary(InputStream in) throws IOException {
        String digest;
        File tmp = this.fileCache.getTempFile();
        FileOutputStream out = new FileOutputStream(tmp);
        try {
            digest = this.storeAndDigest(in, out);
        }
        finally {
            in.close();
            ((OutputStream)out).close();
        }
        File cachedFile = this.fileCache.getFile(digest);
        if (cachedFile != null) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = cachedFile::getAbsolutePath;
            log.debug("File is in the cache -> {}", supplierArray);
            if (Framework.isTestModeSet()) {
                Framework.getProperties().setProperty("cachedBinary", digest);
            }
            if (this.fileStorage.exists(digest)) {
                log.trace("File: {} exists in remote storage", (Object)digest);
            } else {
                log.info("File: {} does not exist in remote storage", (Object)digest);
                this.fileStorage.storeFile(digest, cachedFile);
            }
            tmp.delete();
        } else {
            this.fileStorage.storeFile(digest, tmp);
            this.fileCache.putFile(digest, tmp);
        }
        return this.getBinary(digest);
    }

    @Override
    public Binary getBinary(String digest) {
        return new LazyBinary(digest, this.blobProviderId, this);
    }

    public File getFile(String digest) throws IOException {
        log.debug("Getting file: {}", (Object)digest);
        File file = this.fileCache.getFile(digest);
        if (file != null) {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = digest::toString;
            supplierArray[1] = file::getAbsolutePath;
            log.debug("File: {} retrieved from cache : {}", supplierArray);
            return file;
        }
        File tmp = this.fileCache.getTempFile();
        if (this.fileStorage.fetchFile(digest, tmp)) {
            file = this.fileCache.putFile(digest, tmp);
            Supplier[] supplierArray = new Supplier[3];
            supplierArray[0] = digest::toString;
            supplierArray[1] = () -> this.fileStorage.getClass().getName();
            supplierArray[2] = file::getAbsolutePath;
            log.debug("File: {} retrieved from fileStorage: {} with path : {}", supplierArray);
            return file;
        }
        tmp.delete();
        log.debug("File: {} not in storage", (Object)digest);
        return null;
    }
}

