/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.utils;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;

public class ZipFileReader {
    private static final Logger log = LogManager.getLogger(ZipFileReader.class);
    public static final String NUXEO_ZIP_FILE_READER_CHARSET_FALLBACK_KEY = "org.nuxeo.ecm.zip.file.reader.charset.fallback";

    private ZipFileReader() {
    }

    public static ZipFile newZipFile(File file) throws IOException {
        try {
            return new ZipFile(file);
        }
        catch (ZipException ze) {
            log.debug("Failed decoding ZipFile into {}. Checking for a fallback Charset.", (Object)StandardCharsets.UTF_8);
            Optional charsetName = ((ConfigurationService)Framework.getService(ConfigurationService.class)).getString(NUXEO_ZIP_FILE_READER_CHARSET_FALLBACK_KEY);
            Optional<Charset> charset = charsetName.map(Charset::forName);
            if (charset.isPresent()) {
                log.debug("Trying to decode ZipFile into {} as fallback charset.", (Object)charset.get());
                return new ZipFile(file, charset.get());
            }
            log.warn("Failed decoding ZipFile: {}", (Object)file);
            throw ze;
        }
    }

    public static ZipFile newZipFile(String source) throws IOException {
        return ZipFileReader.newZipFile(new File(source));
    }
}

