/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.convert.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;
import org.nuxeo.ecm.core.convert.service.ConvertOption;

public class MimeTypeTranslationHelper {
    private static final Logger log = LogManager.getLogger(MimeTypeTranslationHelper.class);
    public static final String ANY_MIME_TYPE = "*";
    public static final Pattern MIME_TYPE_PATTERN = Pattern.compile("(.*?);(.*)", 32);
    protected final Map<String, List<ConvertOption>> srcMappings = new HashMap<String, List<ConvertOption>>();
    protected final Map<String, List<ConvertOption>> dstMappings = new HashMap<String, List<ConvertOption>>();

    public void addConverter(ConverterDescriptor desc) {
        List<String> sMts = desc.getSourceMimeTypes();
        String dMt = desc.getDestinationMimeType();
        List dco = this.dstMappings.computeIfAbsent(dMt, key -> new ArrayList());
        for (String sMT : sMts) {
            List sco = this.srcMappings.computeIfAbsent(sMT, key -> new ArrayList());
            sco.add(new ConvertOption(desc.getConverterName(), dMt));
            dco.add(new ConvertOption(desc.getConverterName(), sMT));
        }
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = desc::getSourceMimeTypes;
        supplierArray[1] = desc::getDestinationMimeType;
        log.debug("Added converter {} to {}", supplierArray);
    }

    public String getConverterName(String sourceMimeType, String destinationMimeType) {
        return this.getConverterName(sourceMimeType, destinationMimeType, true);
    }

    public String getConverterName(String sourceMimeType, String destinationMimeType, boolean allowWildcard) {
        List<String> converterNames = this.getConverterNames(sourceMimeType, destinationMimeType, allowWildcard);
        return converterNames.isEmpty() ? null : converterNames.get(converterNames.size() - 1);
    }

    public boolean hasCompatibleMimeType(List<String> mimeTypes, String mimeType) {
        String mt = this.parseMimeType(mimeType);
        HashSet<String> expectedMimeTypes = new HashSet<String>();
        expectedMimeTypes.add(ANY_MIME_TYPE);
        if (mt != null) {
            expectedMimeTypes.add(mt);
            expectedMimeTypes.add(this.computeMimeTypeWithWildcardSubType(mt));
        }
        return mimeTypes.stream().anyMatch(expectedMimeTypes::contains);
    }

    public List<String> getConverterNames(String sourceMimeType, String destinationMimeType) {
        return this.getConverterNames(sourceMimeType, destinationMimeType, true);
    }

    public List<String> getConverterNames(String sourceMimeType, String destinationMimeType, boolean allowWildcard) {
        String srcMimeType = this.parseMimeType(sourceMimeType);
        List<String> converterNames = this.doGetConverterNames(srcMimeType, destinationMimeType);
        if (converterNames.isEmpty()) {
            converterNames = this.doGetConverterNames(this.computeMimeTypeWithWildcardSubType(srcMimeType), destinationMimeType);
        }
        if (converterNames.isEmpty() && allowWildcard) {
            converterNames = this.doGetConverterNames(ANY_MIME_TYPE, destinationMimeType);
        }
        return converterNames;
    }

    protected String parseMimeType(String mimeType) {
        if (mimeType == null) {
            return null;
        }
        return MIME_TYPE_PATTERN.matcher(mimeType).replaceAll("$1").trim();
    }

    protected String computeMimeTypeWithWildcardSubType(String mimeType) {
        return mimeType != null ? mimeType.replaceAll("(.*)/(.*)", "$1/*") : null;
    }

    protected List<String> doGetConverterNames(String sourceMimeType, String destinationMimeType) {
        return this.srcMappings.getOrDefault(sourceMimeType, List.of()).stream().filter(co -> destinationMimeType == null || destinationMimeType.equals(co.mimeType)).map(co -> co.converter).collect(Collectors.toList());
    }

    @Deprecated
    public List<String> getDestinationMimeTypes(String sourceMimeType) {
        ArrayList<String> dst = new ArrayList<String>();
        List<ConvertOption> sco = this.srcMappings.get(sourceMimeType);
        if (sco != null) {
            for (ConvertOption co : sco) {
                dst.add(co.getMimeType());
            }
        }
        return dst;
    }

    @Deprecated
    public List<String> getSourceMimeTypes(String destinationMimeType) {
        ArrayList<String> src = new ArrayList<String>();
        List<ConvertOption> dco = this.dstMappings.get(destinationMimeType);
        if (dco != null) {
            for (ConvertOption co : dco) {
                src.add(co.getMimeType());
            }
        }
        return src;
    }

    public void clear() {
        this.dstMappings.clear();
        this.srcMappings.clear();
        log.debug("clear");
    }
}

