/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.impl.DataModelImpl;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.api.model.DocumentPart;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.api.model.PropertyVisitor;
import org.nuxeo.ecm.core.api.model.impl.DocumentPartImpl;
import org.nuxeo.ecm.core.api.model.resolver.DocumentPropertyObjectResolverImpl;
import org.nuxeo.ecm.core.api.model.resolver.PropertyObjectResolver;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.ComplexTypeImpl;
import org.nuxeo.ecm.core.schema.types.CompositeType;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.runtime.api.Framework;

public class SimpleDocumentModel
implements DocumentModel {
    private static final long serialVersionUID = 1L;
    protected final Map<String, DataModel> dataModels = new HashMap<String, DataModel>();
    protected final Set<String> schemas = new HashSet<String>();
    protected final Set<String> facets = new HashSet<String>();
    protected final Map<String, Serializable> contextData = new HashMap<String, Serializable>();
    protected final boolean anySchema;
    protected Path path;
    protected String type;

    @Deprecated
    public SimpleDocumentModel() {
        this.anySchema = true;
    }

    public static SimpleDocumentModel empty() {
        return new SimpleDocumentModel();
    }

    protected SimpleDocumentModel(DocumentType documentType) {
        this.anySchema = false;
        this.type = documentType.getName();
        this.initSchemas(Arrays.asList(documentType.getSchemaNames()));
    }

    public static SimpleDocumentModel ofType(String type) {
        SchemaManager service = (SchemaManager)Framework.getService(SchemaManager.class);
        DocumentType dType = service.getDocumentType(type);
        return new SimpleDocumentModel(dType);
    }

    @Deprecated
    public SimpleDocumentModel(List<String> schemas) {
        this.anySchema = false;
        this.initSchemas(schemas);
    }

    public static SimpleDocumentModel ofSchemas(List<String> schemas) {
        return new SimpleDocumentModel(schemas);
    }

    @Deprecated
    public SimpleDocumentModel(String ... schemas) {
        this(Arrays.asList(schemas));
    }

    public static SimpleDocumentModel ofSchemas(String schema, String ... schemas) {
        return SimpleDocumentModel.ofSchemas(Stream.concat(Stream.of(schema), Stream.of(schemas)).collect(Collectors.toList()));
    }

    protected final void initSchemas(List<String> schemas) {
        SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        for (String schema : schemas) {
            Schema s = schemaManager.getSchema(schema);
            DocumentPartImpl part = new DocumentPartImpl(s);
            this.dataModels.put(schema, new DataModelImpl(part));
            this.schemas.add(schema);
        }
    }

    protected DataModel getDataModelInternal(String schema) {
        DataModel dm = this.dataModels.get(schema);
        if (dm == null && this.anySchema) {
            SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
            Schema s = schemaManager.getSchema(schema);
            DocumentPartImpl part = new DocumentPartImpl(s);
            dm = new DataModelImpl(part);
            this.dataModels.put(schema, dm);
            this.schemas.add(schema);
        }
        return dm;
    }

    @Override
    public String[] getSchemas() {
        Set<String> keys = this.dataModels.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    @Override
    public Object getProperty(String schemaName, String name) {
        DataModel dm = this.getDataModelInternal(schemaName);
        return dm != null ? dm.getData(name) : null;
    }

    @Override
    public Property getPropertyObject(String schema, String name) {
        DocumentPart part = this.getPart(schema);
        return part == null ? null : part.get(name);
    }

    @Override
    public void setProperty(String schemaName, String name, Object value) {
        if (name.contains(":")) {
            name = name.substring(name.indexOf(":"), name.length());
        }
        this.getDataModelInternal(schemaName).setData(name, value);
    }

    @Override
    public Map<String, Object> getProperties(String schemaName) {
        return this.getDataModelInternal(schemaName).getMap();
    }

    @Override
    public void setProperties(String schemaName, Map<String, Object> data) {
        DataModel dm = this.getDataModelInternal(schemaName);
        dm.setMap(data);
        for (String field : data.keySet()) {
            dm.setDirty(field);
        }
    }

    @Override
    public Map<String, Serializable> getContextData() {
        return this.contextData;
    }

    @Override
    public Serializable getContextData(String key) {
        return this.contextData.get(key);
    }

    @Override
    public void putContextData(String key, Serializable value) {
        this.contextData.put(key, value);
    }

    @Override
    public void copyContextData(DocumentModel otherDocument) {
        this.contextData.putAll(otherDocument.getContextData());
    }

    @Override
    public Property getProperty(String xpath) throws PropertyException {
        if (xpath == null) {
            throw new PropertyNotFoundException("null", "Invalid null xpath");
        }
        String cxpath = ComplexTypeImpl.canonicalXPath((String)xpath);
        if (cxpath.isEmpty()) {
            throw new PropertyNotFoundException(xpath, "Schema not specified");
        }
        String schemaName = DocumentModelImpl.getXPathSchemaName(cxpath, this.schemas, null);
        if (schemaName == null) {
            if (cxpath.indexOf(58) != -1) {
                throw new PropertyNotFoundException(xpath, "No such schema");
            }
            throw new PropertyNotFoundException(xpath);
        }
        DocumentPart part = this.getPart(schemaName);
        if (part == null) {
            throw new PropertyNotFoundException(xpath);
        }
        String partPath = cxpath.substring(cxpath.indexOf(58) + 1);
        try {
            Property property = part.resolvePath(partPath);
            property.setForceDirty(true);
            return property;
        }
        catch (PropertyNotFoundException e) {
            throw new PropertyNotFoundException(xpath, e.getDetail());
        }
    }

    @Override
    public Serializable getPropertyValue(String xpath) throws PropertyException {
        return this.getProperty(xpath).getValue();
    }

    @Override
    public void setPropertyValue(String xpath, Serializable value) {
        this.getProperty(xpath).setValue(value);
    }

    @Override
    public DocumentType getDocumentType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSessionId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CoreSession getCoreSession() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void detach(boolean loadAll) {
    }

    @Override
    public void attach(String sid) {
    }

    @Override
    public DocumentRef getRef() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DocumentRef getParentRef() {
        if (this.path == null) {
            return null;
        }
        if (!this.path.isAbsolute()) {
            return null;
        }
        return new PathRef(this.path.removeLastSegments(1).toString());
    }

    @Override
    public String getId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return this.path == null ? null : this.path.lastSegment();
    }

    @Override
    public Long getPos() {
        return null;
    }

    @Override
    public String getPathAsString() {
        return this.path == null ? null : this.path.toString();
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public String getTitle() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Deprecated
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public Set<String> getFacets() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public Collection<DataModel> getDataModelsCollection() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public Map<String, DataModel> getDataModels() {
        return this.dataModels;
    }

    @Override
    @Deprecated
    public DataModel getDataModel(String schema) {
        return this.getDataModelInternal(schema);
    }

    @Override
    public void setPathInfo(String parentPath, String name) {
        this.path = new Path(parentPath == null ? name : parentPath + '/' + name);
    }

    @Override
    public boolean isLocked() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Lock setLock() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Lock getLockInfo() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Lock removeLock() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ACP getACP() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setACP(ACP acp, boolean overwrite) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasSchema(String schema) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasFacet(String facet) {
        return this.facets.contains(facet);
    }

    @Override
    public boolean addFacet(String facet) {
        if (facet == null) {
            throw new IllegalArgumentException("Null facet");
        }
        if (this.facets.contains(facet)) {
            return false;
        }
        SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        CompositeType facetType = schemaManager.getFacet(facet);
        if (facetType == null) {
            throw new IllegalArgumentException("No such facet: " + facet);
        }
        this.facets.add(facet);
        this.schemas.addAll(Arrays.asList(facetType.getSchemaNames()));
        for (Schema schema : facetType.getSchemas()) {
            DocumentPartImpl part = new DocumentPartImpl(schema);
            this.dataModels.put(schema.getName(), new DataModelImpl(part));
        }
        return true;
    }

    @Override
    public boolean removeFacet(String facet) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isTrashed() {
        return "deleted".equals(this.getCurrentLifeCycleState());
    }

    @Override
    public boolean isFolder() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isVersionable() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDownloadable() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isVersion() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isProxy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isImmutable() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDirty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void accept(PropertyVisitor visitor, Object arg) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T getAdapter(Class<T> itf) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T getAdapter(Class<T> itf, boolean refreshCache) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getCurrentLifeCycleState() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getLifeCyclePolicy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean followTransition(String transition) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<String> getAllowedStateTransitions() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void copyContent(DocumentModel sourceDoc) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getRepositoryName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getCacheKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSourceId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getVersionLabel() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getCheckinComment() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPrefetched(String xpath) {
        return false;
    }

    @Override
    public boolean isPrefetched(String schemaName, String name) {
        return false;
    }

    @Override
    public void prefetchCurrentLifecycleState(String lifecycle) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void prefetchLifeCyclePolicy(String lifeCyclePolicy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLifeCycleLoaded() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends Serializable> T getSystemProp(String systemProperty, Class<T> type) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public DocumentPart getPart(String schema) {
        DataModel dm = this.getDataModel(schema);
        if (dm != null) {
            return ((DataModelImpl)dm).getDocumentPart();
        }
        return null;
    }

    @Override
    @Deprecated
    public DocumentPart[] getParts() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<Property> getPropertyObjects(String schema) {
        DocumentPart part = this.getPart(schema);
        return part == null ? Collections.emptyList() : part.getChildren();
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void refresh(int refreshFlags, String[] schemas) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void refresh() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DocumentModel clone() throws CloneNotSupportedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCheckedOut() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkOut() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DocumentRef checkIn(VersioningOption option, String description) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getVersionSeriesId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLatestVersion() {
        return false;
    }

    @Override
    public boolean isMajorVersion() {
        return false;
    }

    @Override
    public boolean isLatestMajorVersion() {
        return false;
    }

    @Override
    public boolean isVersionSeriesCheckedOut() {
        return true;
    }

    @Override
    public String getChangeToken() {
        return null;
    }

    @Override
    public Map<String, String> getBinaryFulltext() {
        return null;
    }

    @Override
    public PropertyObjectResolver getObjectResolver(String xpath) {
        return DocumentPropertyObjectResolverImpl.create(this, xpath);
    }
}

