/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.blob.PropertyBasedConfiguration;
import org.nuxeo.runtime.api.Framework;

public class AESBlobStoreConfiguration
extends PropertyBasedConfiguration {
    private static final Logger log = LogManager.getLogger(AESBlobStoreConfiguration.class);
    protected static final String AES = "AES";
    protected static final String PBKDF2_WITH_HMAC_SHA1 = "PBKDF2WithHmacSHA1";
    protected static final int PBKDF2_ITERATIONS = 10000;
    protected static final int PBKDF2_KEY_LENGTH = 256;
    protected static final String AES_CBC_PKCS5_PADDING = "AES/CBC/PKCS5Padding";
    protected static final String AES_GCM_NOPADDING = "AES/GCM/NoPadding";
    public static final String PROP_COMPAT_KEY = "key";
    public static final String PROP_PASSWORD = "password";
    public static final String PROP_KEY_STORE_TYPE = "keyStoreType";
    public static final String PROP_KEY_STORE_FILE = "keyStoreFile";
    public static final String PROP_KEY_STORE_PASSWORD = "keyStorePassword";
    public static final String PROP_KEY_ALIAS = "keyAlias";
    public static final String PROP_KEY_PASSWORD = "keyPassword";
    public static final String PROP_KEY_USE_INSECURE_CIPHER = "useInsecureCipher";
    public final boolean usePBKDF2;
    public final String password;
    public final String keyStoreType;
    public final String keyStoreFile;
    public final String keyStorePassword;
    public final String keyAlias;
    public final String keyPassword;
    public final boolean useInsecureCipher;

    public AESBlobStoreConfiguration(Map<String, String> properties) throws IOException {
        super(null, properties);
        this.parseCompat();
        this.password = this.getProperty(PROP_PASSWORD);
        this.keyStoreType = this.getProperty(PROP_KEY_STORE_TYPE);
        this.keyStoreFile = this.getProperty(PROP_KEY_STORE_FILE);
        this.keyStorePassword = this.getProperty(PROP_KEY_STORE_PASSWORD);
        this.keyAlias = this.getProperty(PROP_KEY_ALIAS);
        String keyPassword = this.getProperty(PROP_KEY_PASSWORD);
        this.useInsecureCipher = Boolean.parseBoolean(this.getProperty(PROP_KEY_USE_INSECURE_CIPHER));
        boolean bl = this.usePBKDF2 = this.password != null;
        if (this.usePBKDF2) {
            if (this.keyStoreType != null) {
                throw new NuxeoException("Cannot use keyStoreType with password");
            }
            if (this.keyStoreFile != null) {
                throw new NuxeoException("Cannot use keyStoreFile with password");
            }
            if (this.keyStorePassword != null) {
                throw new NuxeoException("Cannot use keyStorePassword with password");
            }
            if (this.keyAlias != null) {
                throw new NuxeoException("Cannot use keyAlias with password");
            }
            if (keyPassword != null) {
                throw new NuxeoException("Cannot use keyPassword with password");
            }
        } else {
            if (this.keyStoreType == null) {
                throw new NuxeoException("Missing keyStoreType");
            }
            if (this.keyStoreFile == null && this.keyStorePassword != null) {
                throw new NuxeoException("Missing keyStorePassword");
            }
            if (this.keyAlias == null) {
                throw new NuxeoException("Missing keyAlias");
            }
            if (keyPassword == null) {
                keyPassword = this.keyStorePassword;
            }
        }
        this.keyPassword = keyPassword;
    }

    protected void parseCompat() {
        String compatKey = this.getProperty(PROP_COMPAT_KEY);
        if (StringUtils.isBlank((CharSequence)compatKey)) {
            return;
        }
        for (String option : compatKey.split(",")) {
            String[] split = option.split("=", 2);
            if (split.length != 2) {
                log.error("Unrecognized option '" + option + "' in compatibility property '" + PROP_COMPAT_KEY + "'");
                continue;
            }
            String prop = split[0];
            String value = (String)StringUtils.defaultIfBlank((CharSequence)split[1], null);
            if (!Arrays.asList(PROP_PASSWORD, PROP_KEY_STORE_TYPE, PROP_KEY_STORE_FILE, PROP_KEY_STORE_PASSWORD, PROP_KEY_ALIAS, PROP_KEY_PASSWORD, PROP_KEY_USE_INSECURE_CIPHER).contains(prop)) {
                log.error("Unrecognized property '" + prop + "' in compatibility property '" + PROP_COMPAT_KEY + "'");
                continue;
            }
            if (this.properties.containsKey(prop)) {
                log.error("Ignoring property " + option + " in compatibility property '" + PROP_COMPAT_KEY + "' because it is already present as a standard property");
                continue;
            }
            this.properties.put(prop, value);
        }
    }

    protected Key generateSecretKey(byte[] salt) throws GeneralSecurityException {
        char[] pw = this.password.toCharArray();
        SecretKeyFactory factory = SecretKeyFactory.getInstance(PBKDF2_WITH_HMAC_SHA1);
        PBEKeySpec spec = new PBEKeySpec(pw, salt, 10000, 256);
        SecretKey derived = factory.generateSecret(spec);
        spec.clearPassword();
        return new SecretKeySpec(derived.getEncoded(), AES);
    }

    protected Key getSecretKey() throws GeneralSecurityException, IOException {
        KeyStore keyStore = KeyStore.getInstance(this.keyStoreType);
        char[] kspw = this.keyStorePassword == null ? null : this.keyStorePassword.toCharArray();
        String keyStoreFile = this.keyStoreFile;
        if (Framework.isTestModeSet() && keyStoreFile != null) {
            keyStoreFile = Framework.expandVars((String)keyStoreFile);
        }
        if (keyStoreFile == null) {
            keyStore.load(null, kspw);
        } else {
            try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(Paths.get(keyStoreFile, new String[0]), new OpenOption[0]));){
                keyStore.load(in, kspw);
            }
        }
        char[] kpw = this.keyPassword == null ? null : this.keyPassword.toCharArray();
        return keyStore.getKey(this.keyAlias, kpw);
    }

    protected Cipher getCipher() throws GeneralSecurityException {
        if (this.useInsecureCipher) {
            return Cipher.getInstance(AES_CBC_PKCS5_PADDING);
        }
        return Cipher.getInstance(AES_GCM_NOPADDING);
    }

    protected AlgorithmParameterSpec getParameterSpec(byte[] iv) {
        if (this.useInsecureCipher) {
            return new IvParameterSpec(iv);
        }
        return new GCMParameterSpec(128, iv);
    }
}

