/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;
import org.nuxeo.ecm.core.blob.PropertyBasedConfiguration;

public class DigestConfiguration
extends PropertyBasedConfiguration {
    public static final String DIGEST_ALGORITHM_PROPERTY = "digest";
    public static final String DEFAULT_DIGEST_ALGORITHM = "MD5";
    public final String digestAlgorithm;
    public final Pattern digestPattern;

    public DigestConfiguration(String digestAlgorithm) {
        super(null, null);
        this.digestAlgorithm = digestAlgorithm;
        this.digestPattern = this.getDigestPattern();
    }

    public DigestConfiguration(String systemPropertyPrefix, Map<String, String> properties) {
        super(systemPropertyPrefix, properties);
        this.digestAlgorithm = this.getDigestAlgorithm();
        this.digestPattern = this.getDigestPattern();
    }

    protected String getDigestAlgorithm() {
        return this.getProperty(DIGEST_ALGORITHM_PROPERTY, DEFAULT_DIGEST_ALGORITHM).toUpperCase(Locale.ENGLISH);
    }

    protected Pattern getDigestPattern() {
        int len = new DigestUtils(this.digestAlgorithm).digestAsHex(new byte[0]).length();
        return Pattern.compile("[0-9a-f]{" + len + "}");
    }

    public boolean isValidDigest(String digest) {
        return this.digestPattern.matcher(digest).matches();
    }
}

