/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import java.io.IOException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.NuxeoException;

public abstract class PathStrategy {
    private static final Logger log = LogManager.getLogger(PathStrategy.class);
    protected final Path dir;

    public PathStrategy(Path dir) {
        this.dir = dir.normalize();
    }

    public Path createTempFile() {
        try {
            return Files.createTempFile(this.dir, "bin_", ".tmp", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new NuxeoException(e);
        }
    }

    public abstract Path getPathForKey(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void atomicMove(Path source, Path dest) throws IOException {
        try {
            Files.move(source, dest, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (AtomicMoveNotSupportedException amnse) {
            log.debug("Unoptimized atomic move from " + source + " to " + dest);
            Path tmp = Files.createTempFile(dest.getParent(), "bin_", ".tmp", new FileAttribute[0]);
            try {
                Files.copy(source, tmp, StandardCopyOption.REPLACE_EXISTING);
                Files.move(tmp, dest, StandardCopyOption.ATOMIC_MOVE);
                Files.delete(source);
            }
            finally {
                try {
                    Files.deleteIfExists(tmp);
                }
                catch (IOException e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
        }
    }
}

