/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob.binary;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.blob.LocalBlobStoreConfiguration;
import org.nuxeo.ecm.core.blob.binary.AbstractBinaryManager;
import org.nuxeo.ecm.core.blob.binary.Binary;
import org.nuxeo.ecm.core.blob.binary.BinaryGarbageCollector;
import org.nuxeo.ecm.core.blob.binary.BinaryManagerStatus;
import org.nuxeo.runtime.trackers.files.FileEventTracker;

public class LocalBinaryManager
extends AbstractBinaryManager {
    private static final Log log = LogFactory.getLog(LocalBinaryManager.class);
    @Deprecated
    public static final Pattern WINDOWS_ABSOLUTE_PATH = Pattern.compile("[a-zA-Z]:[/\\\\].*");
    @Deprecated
    public static final String DEFAULT_PATH = "binaries";
    @Deprecated
    public static final String DATA = "data";
    @Deprecated
    public static final String TMP = "tmp";
    @Deprecated
    public static final String CONFIG_FILE = "config.xml";
    protected File storageDir;
    protected File tmpDir;

    @Override
    public void initialize(String blobProviderId, Map<String, String> properties) throws IOException {
        super.initialize(blobProviderId, properties);
        LocalBlobStoreConfiguration config = new LocalBlobStoreConfiguration(properties);
        log.info((Object)("Registering binary manager '" + blobProviderId + "' using " + (this.getClass().equals(LocalBinaryManager.class) ? "" : this.getClass().getSimpleName() + " and ") + "binary store: " + config.storageDir.getParent()));
        this.storageDir = config.storageDir.toFile();
        this.tmpDir = config.tmpDir.toFile();
        this.storageDir.mkdirs();
        this.tmpDir.mkdirs();
        this.setDescriptor(config.descriptor);
        this.createGarbageCollector();
        FileEventTracker.registerProtectedPath((String)this.storageDir.getAbsolutePath());
    }

    @Override
    public void close() {
        if (this.tmpDir != null) {
            try {
                FileUtils.cleanDirectory((File)this.tmpDir);
            }
            catch (IOException e) {
                throw new NuxeoException(e);
            }
        }
    }

    public File getStorageDir() {
        return this.storageDir;
    }

    @Override
    protected Binary getBinary(InputStream in) throws IOException {
        String digest = this.storeAndDigest(in);
        File file = this.getFileForDigest(digest, false);
        return new Binary(file, digest, this.blobProviderId);
    }

    @Override
    public Binary getBinary(String digest) {
        File file = this.getFileForDigest(digest, false);
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            log.warn((Object)("cannot fetch content at " + file.getPath() + " (file does not exist), check your configuration"));
            return null;
        }
        return new Binary(file, digest, this.blobProviderId);
    }

    public File getFileForDigest(String digest, boolean createDir) {
        int depth = this.descriptor.depth;
        if (digest.length() < 2 * depth) {
            return null;
        }
        StringBuilder buf = new StringBuilder(3 * depth - 1);
        for (int i = 0; i < depth; ++i) {
            if (i != 0) {
                buf.append(File.separatorChar);
            }
            buf.append(digest.substring(2 * i, 2 * i + 2));
        }
        File dir = new File(this.storageDir, buf.toString());
        if (createDir) {
            dir.mkdirs();
        }
        return new File(dir, digest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String storeAndDigest(InputStream in) throws IOException {
        long startTime = System.currentTimeMillis();
        log.debug((Object)("Starting storeAndDigest for file with size " + in.available()));
        log.debug((Object)"Create tmp file in storeAndDigest");
        File tmp = File.createTempFile("create_", ".tmp", this.tmpDir);
        log.debug((Object)("End create tmp file storeAndDigest for" + tmp.getAbsolutePath()));
        try {
            String digest;
            Object object;
            try {
                FileOutputStream out = new FileOutputStream(tmp);
                object = null;
                try {
                    digest = this.storeAndDigest(in, out);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (out != null) {
                        if (object != null) {
                            try {
                                ((OutputStream)out).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            ((OutputStream)out).close();
                        }
                    }
                }
            }
            finally {
                in.close();
            }
            File file = this.getFileForDigest(digest, true);
            log.debug((Object)"Begin atomicMove");
            this.atomicMove(tmp, file);
            log.debug((Object)"End atomicMove");
            object = digest;
            return object;
        }
        finally {
            log.debug((Object)"Begin temp file delete for storeAndDigest");
            tmp.delete();
            log.debug((Object)"End temp file delete for storeAndDigest");
            long endTime = System.currentTimeMillis();
            log.debug((Object)("End storeAndDigest. Total time to store: " + (endTime - startTime) + " ms"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void atomicMove(File source, File dest) throws IOException {
        if (dest.exists()) {
            dest.setLastModified(source.lastModified());
            return;
        }
        if (!source.renameTo(dest)) {
            log.debug((Object)"Create tmp file atomicMove");
            File tmp = File.createTempFile(dest.getName(), ".tmp", dest.getParentFile());
            log.debug((Object)("End create tmp file atomicMove for " + tmp.getAbsolutePath()));
            try {
                try (FileInputStream in = new FileInputStream(source);
                     FileOutputStream out = new FileOutputStream(tmp);){
                    log.debug((Object)"Start copy content");
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    log.debug((Object)"End copy content");
                }
                tmp.renameTo(dest);
            }
            finally {
                log.debug((Object)"Start delete tmp file for atomicMove");
                tmp.delete();
                log.debug((Object)"End delete tmp file for atomicMove");
            }
            log.debug((Object)"Start delete source file");
            source.delete();
            log.debug((Object)"End delete source file");
        }
        if (!dest.exists()) {
            throw new IOException("Could not create file: " + dest);
        }
    }

    protected void createGarbageCollector() {
        this.garbageCollector = new DefaultBinaryGarbageCollector(this);
    }

    public static void touch(File file) {
        long time = System.currentTimeMillis();
        if (file.setLastModified(time)) {
            return;
        }
        if (!file.canWrite()) {
            return;
        }
        try (RandomAccessFile r = new RandomAccessFile(file, "rw");){
            r.setLength(r.length());
        }
        catch (IOException e) {
            log.error((Object)("Cannot set last modified for file: " + file), (Throwable)e);
        }
    }

    public static class DefaultBinaryGarbageCollector
    implements BinaryGarbageCollector {
        public static final int TIME_RESOLUTION = 2000;
        protected final LocalBinaryManager binaryManager;
        protected volatile long startTime;
        protected BinaryManagerStatus status;

        public DefaultBinaryGarbageCollector(LocalBinaryManager binaryManager) {
            this.binaryManager = binaryManager;
        }

        @Override
        public String getId() {
            return this.binaryManager.getStorageDir().toURI().toString();
        }

        @Override
        public BinaryManagerStatus getStatus() {
            return this.status;
        }

        @Override
        public boolean isInProgress() {
            return this.startTime != 0L;
        }

        @Override
        public void start() {
            if (this.startTime != 0L) {
                throw new RuntimeException("Alread started");
            }
            this.startTime = System.currentTimeMillis();
            this.status = new BinaryManagerStatus();
        }

        @Override
        public void mark(String digest) {
            File file = this.binaryManager.getFileForDigest(digest, false);
            if (!file.exists()) {
                log.error((Object)("Unknown file digest: " + digest));
                return;
            }
            LocalBinaryManager.touch(file);
        }

        @Override
        public void stop(boolean delete) {
            if (this.startTime == 0L) {
                throw new RuntimeException("Not started");
            }
            this.deleteOld(this.binaryManager.getStorageDir(), this.startTime - 2000L, 0, delete);
            this.status.gcDuration = System.currentTimeMillis() - this.startTime;
            this.startTime = 0L;
        }

        protected void deleteOld(File file, long minTime, int depth, boolean delete) {
            if (file.isDirectory()) {
                for (File f : file.listFiles()) {
                    this.deleteOld(f, minTime, depth + 1, delete);
                }
                if (depth > 0 && file.list().length == 0) {
                    file.delete();
                }
            } else if (file.isFile() && file.canWrite()) {
                long lastModified = file.lastModified();
                long length = file.length();
                if (lastModified == 0L) {
                    log.error((Object)("Cannot read last modified for file: " + file));
                } else if (lastModified < minTime) {
                    this.status.sizeBinariesGC += length;
                    ++this.status.numBinariesGC;
                    if (delete && !file.delete()) {
                        log.warn((Object)("Cannot gc file: " + file));
                    }
                } else {
                    this.status.sizeBinaries += length;
                    ++this.status.numBinaries;
                }
            }
        }
    }
}

