/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.easyshare;

import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.easyshare.EasyShareUnrestrictedRunner;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.jaxrs.io.documents.PaginableDocumentModelListImpl;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.platform.ec.notification.email.EmailHelper;
import org.nuxeo.ecm.platform.ec.notification.service.NotificationServiceHelper;
import org.nuxeo.ecm.platform.notification.api.Notification;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.ModuleRoot;
import org.nuxeo.runtime.api.Framework;

@Path(value="/easyshare")
@Produces(value={"text/html;charset=UTF-8"})
@WebObject(type="EasyShare")
public class EasyShare
extends ModuleRoot {
    private static final String DEFAULT_PAGE_INDEX = "0";
    private static final Long PAGE_SIZE = 20L;
    private static final String SHARE_DOC_TYPE = "EasyShareFolder";
    private static AutomationService automationService;
    protected final Log log = LogFactory.getLog(EasyShare.class);

    @GET
    public Object doGet() {
        return this.getView("index");
    }

    public EasyShareUnrestrictedRunner buildUnrestrictedRunner(final String docId, final Long pageIndex) {
        return new EasyShareUnrestrictedRunner(){

            @Override
            public Object run(CoreSession session, IdRef docRef) throws NuxeoException {
                if (session.exists((DocumentRef)docRef)) {
                    DocumentModel docShare = session.getDocument((DocumentRef)docRef);
                    if (!EasyShare.SHARE_DOC_TYPE.equals(docShare.getType())) {
                        return Response.serverError().status(Response.Status.NOT_FOUND).build();
                    }
                    if (!EasyShare.this.checkIfShareIsValid(docShare)) {
                        return EasyShare.this.getView("expired").arg("docShare", (Object)docShare);
                    }
                    DocumentModel document = session.getDocument((DocumentRef)new IdRef(docId));
                    String query = EasyShare.buildQuery(document);
                    if (query == null) {
                        return EasyShare.this.getView("denied");
                    }
                    try {
                        OperationContext opCtx = new OperationContext(session);
                        OperationChain chain = new OperationChain("getEasyShareContent");
                        chain.add("Document.Query").set("query", (Object)query).set("currentPageIndex", (Object)pageIndex).set("pageSize", (Object)PAGE_SIZE);
                        PaginableDocumentModelListImpl paginable = (PaginableDocumentModelListImpl)EasyShare.getAutomationService().run(opCtx, chain);
                        OperationContext ctx = new OperationContext(session);
                        ctx.setInput((Object)docShare);
                        HashMap<String, String> params = new HashMap<String, String>();
                        params.put("event", "Access");
                        params.put("category", "Document");
                        params.put("comment", "IP: " + EasyShare.this.getIpAddr());
                        EasyShare.getAutomationService().run(ctx, "Audit.Log", params);
                        return EasyShare.this.getView("folderList").arg("isFolder", (Object)(document.isFolder() && !EasyShare.SHARE_DOC_TYPE.equals(document.getType()) ? 1 : 0)).arg("currentPageIndex", (Object)paginable.getCurrentPageIndex()).arg("numberOfPages", (Object)paginable.getNumberOfPages()).arg("docShare", (Object)docShare).arg("docList", (Object)paginable).arg("previousPageAvailable", (Object)paginable.isPreviousPageAvailable()).arg("nextPageAvailable", (Object)paginable.isNextPageAvailable()).arg("currentPageStatus", (Object)paginable.getProvider().getCurrentPageStatus());
                    }
                    catch (Exception ex) {
                        EasyShare.this.log.error((Object)ex.getMessage());
                        return EasyShare.this.getView("denied");
                    }
                }
                return EasyShare.this.getView("denied");
            }
        };
    }

    protected static String buildQuery(DocumentModel documentModel) {
        if (documentModel.isFolder() && !SHARE_DOC_TYPE.equals(documentModel.getType())) {
            return " SELECT * FROM Document WHERE ecm:parentId = '" + documentModel.getId() + "' AND " + "ecm:mixinType != 'HiddenInNavigation' AND " + "ecm:mixinType != 'NotCollectionMember' AND " + "ecm:isCheckedInVersion = 0 AND " + "ecm:currentLifeCycleState != 'deleted'" + "ORDER BY dc:title";
        }
        if (SHARE_DOC_TYPE.equals(documentModel.getType())) {
            return "SELECT * FROM Document where ecm:mixinType != 'HiddenInNavigation' AND ecm:isCheckedInVersion = 0 AND ecm:currentLifeCycleState != 'deleted' AND collectionMember:collectionIds/* = '" + documentModel.getId() + "'" + "OR ecm:parentId = '" + documentModel.getId() + "'" + "ORDER BY dc:title";
        }
        return null;
    }

    private boolean checkIfShareIsValid(DocumentModel docShare) {
        Date today = new Date();
        if (today.after((Date)docShare.getProperty("dc:expired").getValue(Date.class))) {
            HashMap<String, Object> mail = new HashMap<String, Object>();
            this.sendNotification("easyShareExpired", docShare, mail);
            return false;
        }
        return true;
    }

    private static AutomationService getAutomationService() {
        if (automationService == null) {
            automationService = (AutomationService)Framework.getService(AutomationService.class);
        }
        return automationService;
    }

    @Path(value="{shareId}/{folderId}")
    @GET
    public Object getFolderListing(@PathParam(value="shareId") String shareId, @PathParam(value="folderId") String folderId, @DefaultValue(value="0") @QueryParam(value="p") Long pageIndex) {
        return this.buildUnrestrictedRunner(folderId, pageIndex).runUnrestricted(shareId);
    }

    @Path(value="{shareId}")
    @GET
    public Object getShareListing(@PathParam(value="shareId") String shareId, @DefaultValue(value="0") @QueryParam(value="p") Long pageIndex) {
        return this.buildUnrestrictedRunner(shareId, pageIndex).runUnrestricted(shareId);
    }

    public String getFileName(DocumentModel doc) throws NuxeoException {
        BlobHolder blobHolder = (BlobHolder)doc.getAdapter(BlobHolder.class);
        if (blobHolder != null && blobHolder.getBlob() != null) {
            return blobHolder.getBlob().getFilename();
        }
        return doc.getName();
    }

    @GET
    @Path(value="{shareId}/{fileId}/{fileName}")
    public Response getFileStream(final @PathParam(value="shareId") String shareId, @PathParam(value="fileId") String fileId) throws NuxeoException {
        return (Response)new EasyShareUnrestrictedRunner(){

            @Override
            public Object run(CoreSession session, IdRef docRef) throws NuxeoException {
                if (session.exists((DocumentRef)docRef)) {
                    try {
                        DocumentModel doc = session.getDocument((DocumentRef)docRef);
                        DocumentModel docShare = session.getDocument((DocumentRef)new IdRef(shareId));
                        if (!EasyShare.this.checkIfShareIsValid(docShare)) {
                            return Response.serverError().status(Response.Status.NOT_FOUND).build();
                        }
                        Blob blob = ((BlobHolder)doc.getAdapter(BlobHolder.class)).getBlob();
                        OperationContext ctx = new OperationContext(session);
                        ctx.setInput((Object)doc);
                        HashMap<String, String> params = new HashMap<String, String>();
                        params.put("event", "Download");
                        params.put("category", "Document");
                        params.put("comment", "IP: " + EasyShare.this.getIpAddr());
                        AutomationService service = (AutomationService)Framework.getLocalService(AutomationService.class);
                        service.run(ctx, "Audit.Log", params);
                        if (doc.isProxy()) {
                            DocumentModel liveDoc = session.getSourceDocument((DocumentRef)docRef);
                            ctx.setInput((Object)liveDoc);
                            service.run(ctx, "Audit.Log", params);
                        }
                        HashMap<String, Object> mail = new HashMap<String, Object>();
                        mail.put("filename", blob.getFilename());
                        EasyShare.this.sendNotification("easyShareDownload", docShare, mail);
                        return Response.ok((Object)blob.getStream(), (String)blob.getMimeType()).build();
                    }
                    catch (Exception ex) {
                        EasyShare.this.log.error((Object)"error ", (Throwable)ex);
                        return Response.serverError().status(Response.Status.NOT_FOUND).build();
                    }
                }
                return Response.serverError().status(Response.Status.NOT_FOUND).build();
            }
        }.runUnrestricted(fileId);
    }

    public void sendNotification(String notification, DocumentModel docShare, Map<String, Object> mail) {
        Boolean hasNotification = (Boolean)docShare.getProperty("eshare:hasNotification").getValue(Boolean.class);
        if (hasNotification.booleanValue()) {
            String email = (String)docShare.getProperty("eshare:contactEmail").getValue(String.class);
            if (StringUtils.isEmpty((String)email)) {
                return;
            }
            try {
                this.log.debug((Object)"Easyshare: starting email");
                EmailHelper emailHelper = new EmailHelper();
                Hashtable<String, Object> mailProps = new Hashtable<String, Object>();
                mailProps.put("mail.from", Framework.getProperty((String)"mail.from", (String)"system@nuxeo.com"));
                mailProps.put("mail.to", email);
                mailProps.put("ip", this.getIpAddr());
                mailProps.put("docShare", docShare);
                try {
                    Notification notif = NotificationServiceHelper.getNotificationService().getNotificationByName(notification);
                    if (notif.getSubjectTemplate() != null) {
                        mailProps.put("subjectTemplate", notif.getSubjectTemplate());
                    }
                    mailProps.put("subject", NotificationServiceHelper.getNotificationService().getEMailSubjectPrefix() + " " + notif.getSubject());
                    mailProps.put("template", notif.getTemplate());
                    mailProps.putAll(mail);
                    emailHelper.sendmail(mailProps);
                }
                catch (NuxeoException e) {
                    this.log.warn((Object)e.getMessage());
                }
                this.log.debug((Object)"Easyshare: completed email");
            }
            catch (Exception ex) {
                this.log.error((Object)"Cannot send easyShare notification email", (Throwable)ex);
            }
        }
    }

    protected String getIpAddr() {
        String ip = this.request.getHeader("X-FORWARDED-FOR");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = this.request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = this.request.getRemoteAddr();
        }
        return ip;
    }
}

