/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.app;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.webengine.app.JsonWebengineWriter;
import org.nuxeo.ecm.webengine.model.Template;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.runtime.api.Framework;

@Singleton
@Provider
@Produces(value={"text/html;qs=0.1"})
public class HtmlNuxeoExceptionWriter
implements MessageBodyWriter<NuxeoException> {
    protected static final String TYPE_TEXT_HTML = "text/html;qs=0.1";
    @Inject
    protected WebContext webContext;

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return NuxeoException.class.isAssignableFrom(type) && mediaType != null;
    }

    public void writeTo(NuxeoException e, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        HashMap<String, Object> exceptionArgs = new HashMap<String, Object>();
        exceptionArgs.put("message", JsonWebengineWriter.getExceptionMessage(e));
        exceptionArgs.put("statusCode", e.getStatusCode());
        if (Framework.isDevModeSet()) {
            try (ByteArrayOutputStream stream = new ByteArrayOutputStream();
                 PrintWriter printer = new PrintWriter(stream, true);){
                e.printStackTrace(printer);
                String stackTrace = stream.toString();
                exceptionArgs.put("stackTrace", stackTrace);
            }
        }
        new Template(this.webContext.getRoot(), "error.html.ftl").arg("exception", exceptionArgs).arg("isDevModeSet", Framework.isDevModeSet()).render(entityStream);
    }
}

