/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.app;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import jakarta.ws.rs.core.MediaType;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.webengine.JsonFactoryManager;
import org.nuxeo.runtime.api.Framework;

public class JsonWebengineWriter {
    public static final String SHOW_EXCEPTION_MESSAGE = "org.nuxeo.rest.exception.message.enabled";

    private static JsonFactory getFactory() {
        return ((JsonFactoryManager)Framework.getService(JsonFactoryManager.class)).getJsonFactory();
    }

    private static JsonGenerator createGenerator(OutputStream out) throws IOException {
        return JsonWebengineWriter.getFactory().createGenerator(out, JsonEncoding.UTF8);
    }

    public static void writeException(OutputStream out, NuxeoException nuxeoException, MediaType mediaType) throws IOException {
        JsonWebengineWriter.writeException(JsonWebengineWriter.createGenerator(out), nuxeoException, mediaType);
    }

    public static void writeException(JsonGenerator jg, NuxeoException nuxeoException, MediaType mediaType) throws IOException {
        JsonWebengineWriter.writeException(jg, nuxeoException, mediaType, nuxeoException.getStatusCode());
    }

    protected static void writeException(JsonGenerator jg, Throwable t, MediaType mediaType, int statusCode) throws IOException {
        jg.writeStartObject();
        jg.writeStringField("entity-type", "exception");
        jg.writeNumberField("status", statusCode);
        jg.writeStringField("message", JsonWebengineWriter.getExceptionMessage(t.getMessage(), statusCode));
        if (((JsonFactoryManager)Framework.getService(JsonFactoryManager.class)).isStackDisplay()) {
            jg.writeStringField("stacktrace", JsonWebengineWriter.getStackTraceString(t));
            jg.writeObjectField("exception", (Object)t);
        }
        jg.writeEndObject();
        jg.flush();
    }

    protected static String getExceptionMessage(NuxeoException e) {
        return JsonWebengineWriter.getExceptionMessage(e.getMessage(), e.getStatusCode());
    }

    protected static String getExceptionMessage(String exceptionMessage, int statusCode) {
        if (statusCode < 500 || ((JsonFactoryManager)Framework.getService(JsonFactoryManager.class)).isStackDisplay() || Framework.isDevModeSet()) {
            if (Framework.isBooleanPropertyFalse((String)SHOW_EXCEPTION_MESSAGE)) {
                return "An error occured";
            }
            return exceptionMessage;
        }
        return "Internal Server Error";
    }

    protected static String getStackTraceString(Throwable t) throws IOException {
        try (StringWriter sw = new StringWriter();){
            PrintWriter pw = new PrintWriter(sw);
            try {
                t.printStackTrace(pw);
                String string = sw.toString();
                pw.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    pw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }
}

