/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.app;

import jakarta.inject.Singleton;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.validation.DocumentValidationException;
import org.nuxeo.ecm.webengine.model.ModuleResource;
import org.nuxeo.ecm.webengine.model.Resource;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

@Singleton
@Provider
public class WebEngineExceptionMapper
implements ExceptionMapper<Throwable> {
    private static final Logger log = LogManager.getLogger(WebEngineExceptionMapper.class);
    @Context
    protected HttpHeaders headers;
    @Context
    protected WebContext webContext;

    public Response toResponse(Throwable cause) {
        TransactionHelper.setTransactionRollbackOnly();
        if (this.headers.getAcceptableMediaTypes().contains(MediaType.APPLICATION_JSON_TYPE) && cause instanceof DocumentValidationException) {
            DocumentValidationException dve = (DocumentValidationException)cause;
            return Response.status((int)dve.getStatusCode()).entity((Object)dve.getReport()).build();
        }
        Object result = this.handleErrorOnWebModule(cause);
        if (result instanceof Throwable) {
            cause = (Throwable)result;
        } else {
            if (result instanceof Response) {
                Response response = (Response)result;
                return response;
            }
            if (result != null) {
                return Response.status((int)500).entity(result).build();
            }
        }
        int statusCode = WebEngineExceptionMapper.getStatusCode(cause);
        if (statusCode >= 500) {
            log.error((Object)cause, cause);
        } else if (Framework.isDevModeSet()) {
            log.warn((Object)cause, cause);
        } else {
            log.debug((Object)cause, cause);
        }
        return Response.status((int)statusCode).entity((Object)(cause instanceof NuxeoException ? cause : new NuxeoException(cause, statusCode))).build();
    }

    protected static int getStatusCode(Throwable t) {
        if (t instanceof WebApplicationException) {
            WebApplicationException e = (WebApplicationException)t;
            return e.getResponse().getStatus();
        }
        if (t instanceof NuxeoException) {
            NuxeoException e = (NuxeoException)t;
            return e.getStatusCode();
        }
        if (t instanceof SecurityException) {
            return 403;
        }
        if (t instanceof UnsupportedOperationException) {
            return 501;
        }
        if (t instanceof IllegalArgumentException) {
            return 400;
        }
        Throwable cause = t.getCause();
        if (cause == null || t == cause) {
            return 500;
        }
        return WebEngineExceptionMapper.getStatusCode(cause);
    }

    protected Object handleErrorOnWebModule(Throwable t) {
        Resource resource;
        if (this.webContext != null && (resource = this.webContext.head()) instanceof ModuleResource) {
            ModuleResource mr = (ModuleResource)resource;
            return mr.handleError(t);
        }
        return null;
    }
}

