/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.loader;

import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.webengine.loader.ClassProxy;

public class LazyClassProxy
implements ClassProxy {
    protected final String className;
    protected final ClassLoader loader;
    protected Class<?> clazz;

    public LazyClassProxy(ClassLoader loader, String className) {
        this.loader = loader;
        this.className = className;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    @Override
    public Class<?> get() {
        if (this.clazz == null) {
            try {
                this.clazz = this.loader.loadClass(this.className);
            }
            catch (ReflectiveOperationException e) {
                throw new NuxeoException("Failed to load class " + this.className, (Throwable)e);
            }
        }
        return this.clazz;
    }

    public void reset() {
        this.clazz = null;
    }

    public String toString() {
        return this.className;
    }
}

