/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.loader.store;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.webengine.loader.store.ResourceStore;

public class ResourceStoreClassLoader
extends ClassLoader
implements Cloneable {
    private static final Logger log = LogManager.getLogger(ResourceStoreClassLoader.class);
    private volatile ResourceStore[] stores;
    private final LinkedHashSet<ResourceStore> cp;

    public ResourceStoreClassLoader(ClassLoader pParent) {
        this(pParent, new LinkedHashSet<ResourceStore>());
    }

    protected ResourceStoreClassLoader(ClassLoader pParent, LinkedHashSet<ResourceStore> cp) {
        super(pParent);
        this.cp = cp;
        if (!cp.isEmpty()) {
            this.stores = cp.toArray(new ResourceStore[0]);
        }
    }

    public synchronized boolean addStore(ResourceStore store) {
        if (this.cp.add(store)) {
            this.stores = this.cp.toArray(new ResourceStore[0]);
            return true;
        }
        return false;
    }

    public synchronized boolean removeStore(ResourceStore store) {
        if (this.cp.remove(store)) {
            this.stores = this.cp.toArray(new ResourceStore[0]);
            return true;
        }
        return false;
    }

    public synchronized ResourceStoreClassLoader clone() {
        return new ResourceStoreClassLoader(this.getParent(), new LinkedHashSet<ResourceStore>(this.cp));
    }

    public ResourceStore[] getStores() {
        return this.stores;
    }

    protected Class<?> fastFindClass(String name) {
        ResourceStore[] _stores = this.stores;
        if (_stores != null) {
            for (ResourceStore store : _stores) {
                byte[] clazzBytes = store.getBytes(ResourceStoreClassLoader.convertClassToResourcePath(name));
                if (clazzBytes == null) continue;
                log.trace("{} found class: {} ({} bytes)", (Object)this.getId(), (Object)name, (Object)clazzBytes.length);
                this.doDefinePackage(name);
                return this.defineClass(name, clazzBytes, 0, clazzBytes.length);
            }
        }
        return null;
    }

    protected void doDefinePackage(String name) {
        String pkgname;
        Package pkg;
        int i = name.lastIndexOf(46);
        if (i > -1 && (pkg = this.getDefinedPackage(pkgname = name.substring(0, i))) == null) {
            this.definePackage(pkgname, null, null, null, null, null, null, null);
        }
    }

    @Override
    protected URL findResource(String name) {
        return this.streamResources(name).findFirst().orElse(null);
    }

    @Override
    protected Enumeration<URL> findResources(String name) {
        return this.streamResources(name).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::enumeration));
    }

    private Stream<URL> streamResources(String name) {
        ResourceStore[] _stores = this.stores;
        if (_stores != null) {
            return Stream.of(_stores).map(store -> store.getURL(name)).filter(Objects::nonNull).peek(url -> log.trace("{} found resource: {}", (Object)this.getId(), (Object)name));
        }
        return Stream.empty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(name);
        if (clazz == null) {
            clazz = this.fastFindClass(name);
            if (clazz == null) {
                ClassLoader parent = this.getParent();
                if (parent == null) throw new ClassNotFoundException(name);
                clazz = parent.loadClass(name);
            } else {
                log.debug("{} loaded from store: {}", (Object)this.getId(), (Object)name);
            }
        }
        if (!resolve) return clazz;
        this.resolveClass(clazz);
        return clazz;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> clazz = this.fastFindClass(name);
        if (clazz == null) {
            throw new ClassNotFoundException(name);
        }
        return clazz;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ClassLoader parent;
        Enumeration<URL> urls = this.findResources(name);
        if (urls == null && (parent = this.getParent()) != null) {
            urls = parent.getResources(name);
        }
        return urls;
    }

    @Override
    public URL getResource(String name) {
        ClassLoader parent;
        URL url = this.findResource(name);
        if (url == null && (parent = this.getParent()) != null) {
            url = parent.getResource(name);
        }
        return url;
    }

    protected String getId() {
        return String.valueOf(this) + "[" + String.valueOf(this.getClass().getClassLoader()) + "]";
    }

    public static String convertClassToResourcePath(String pName) {
        return pName.replace('.', '/') + ".class";
    }
}

