/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.model.impl;

import java.util.Objects;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.webengine.loader.ClassProxy;
import org.nuxeo.ecm.webengine.loader.StaticClassProxy;
import org.nuxeo.ecm.webengine.model.WebAdapter;
import org.nuxeo.ecm.webengine.model.impl.TypeDescriptor;

@XObject(value="web-adapter")
public class AdapterDescriptor
extends TypeDescriptor {
    @XNode(value="@name")
    public String name;
    @XNode(value="targetType")
    public String targetType = "*";
    @XNodeList(value="facet", type=String[].class, componentType=String.class, nullByDefault=true)
    public String[] facets;

    @XNode(value="@class")
    void setClass(Class<?> clazz) {
        this.clazz = new StaticClassProxy(clazz);
    }

    @XNode(value="@type")
    void setType(String type) {
        this.type = type;
    }

    @XNode(value="@fragment")
    void setFragment(String fragment) {
        this.fragment = fragment;
    }

    @XNode(value="@superType")
    void setSuperType(String superType) {
        this.superType = superType;
    }

    public AdapterDescriptor() {
    }

    public AdapterDescriptor(ClassProxy clazz, String name, String type, String superType) {
        super(clazz, type, superType);
        this.name = name;
    }

    public AdapterDescriptor(ClassProxy clazz, String name, String type, String superType, String targetType, String[] facets) {
        super(clazz, type, superType);
        this.name = name;
        if (facets != null && facets.length > 0) {
            this.facets = facets;
        }
        this.targetType = targetType == null || "*".equals(targetType) ? "*" : targetType;
    }

    @Override
    public boolean isAdapter() {
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() == AdapterDescriptor.class) {
            AdapterDescriptor td = (AdapterDescriptor)obj;
            return this.type.equals(td.type) && Objects.equals(this.fragment, td.fragment);
        }
        return false;
    }

    @Override
    public String getId() {
        return this.type;
    }

    @Override
    public String getFragment() {
        return this.fragment;
    }

    @Override
    public boolean isMainFragment() {
        return this.fragment == null;
    }

    @Override
    public AdapterDescriptor asAdapterDescriptor() {
        return this;
    }

    public static AdapterDescriptor fromAnnotation(ClassProxy clazz, WebAdapter type) {
        return new AdapterDescriptor(clazz, type.name(), type.type(), type.superType(), type.targetType(), type.facets());
    }
}

