/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.model.impl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.model.impl.ModuleConfiguration;
import org.nuxeo.runtime.api.Framework;

public class ModuleManager {
    private static final Logger log = LogManager.getLogger(ModuleManager.class);
    protected final Map<String, ModuleConfiguration> modules;
    protected final Map<String, ModuleConfiguration> roots;
    protected WebEngine engine;

    public ModuleManager(WebEngine engine) {
        this.engine = engine;
        this.modules = new ConcurrentHashMap<String, ModuleConfiguration>();
        this.roots = new ConcurrentHashMap<String, ModuleConfiguration>();
    }

    public ModuleConfiguration getModule(String key) {
        return this.modules.get(key);
    }

    public ModuleConfiguration[] getModules() {
        return (ModuleConfiguration[])this.modules.values().toArray(ModuleConfiguration[]::new);
    }

    public ModuleConfiguration getModuleByConfigFile(File file) {
        ModuleConfiguration[] ar;
        for (ModuleConfiguration mc : ar = this.getModules()) {
            if (!file.equals(mc.file)) continue;
            return mc;
        }
        return null;
    }

    public synchronized void registerModule(ModuleConfiguration descriptor) {
        log.info("Registering web module: {}", (Object)descriptor.name);
        this.modules.put(descriptor.name, descriptor);
        if (descriptor.roots != null) {
            for (Class<?> cl : descriptor.roots) {
                this.roots.put(cl.getName(), descriptor);
            }
        }
    }

    public synchronized File unregisterModule(String name) {
        ModuleConfiguration md = this.modules.remove(name);
        if (md == null) {
            return null;
        }
        if (md.roots != null) {
            for (Class<?> cl : md.roots) {
                this.roots.remove(cl.getName());
            }
        }
        return md.file;
    }

    public ModuleConfiguration getModuleByRootClass(Class<?> clazz) {
        return this.roots.get(clazz.getName());
    }

    public void loadModules(File root) {
        for (String name : root.list()) {
            String path = name + "/module.xml";
            File file = new File(root, path);
            if (!file.isFile()) continue;
            this.loadModule(file);
        }
    }

    public void loadModule(ModuleConfiguration mc) {
        mc.setEngine(this.engine);
        this.registerModule(mc);
    }

    public void loadModule(File file) {
        ModuleConfiguration md = this.loadConfiguration(file);
        md.setEngine(this.engine);
        this.registerModule(md);
    }

    public void loadModuleFromDir(File moduleRoot) {
        File file = new File(moduleRoot, "module.xml");
        if (file.isFile()) {
            this.loadModule(file);
        }
    }

    public void reloadModule(String name) {
        log.info("Reloading module: {}", (Object)name);
        File cfg = this.unregisterModule(name);
        if (cfg != null) {
            this.loadModule(cfg);
        }
    }

    public void reloadModules() {
        log.info("Reloading modules");
        for (ModuleConfiguration mc : this.getModules()) {
            this.reloadModule(mc.name);
        }
    }

    protected ModuleConfiguration loadConfiguration(File file) {
        if (this.engine == null) {
            this.engine = (WebEngine)Framework.getService(WebEngine.class);
        }
        try {
            ModuleConfiguration mc = ModuleManager.readConfiguration(this.engine, file);
            if (mc.directory == null) {
                mc.directory = file.getParentFile().getCanonicalFile();
            }
            return mc;
        }
        catch (IOException e) {
            throw new NuxeoException("Failed to load module configuration: " + String.valueOf(file), (Throwable)e);
        }
    }

    public static ModuleConfiguration readConfiguration(WebEngine engine, File file) throws IOException {
        XMap xmap = new XMap();
        xmap.register(ModuleConfiguration.class);
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            ModuleConfiguration moduleConfig = (ModuleConfiguration)xmap.load(ModuleManager.createXMapContext(engine), (InputStream)in);
            moduleConfig.setEngine(engine);
            moduleConfig.file = file;
            ModuleConfiguration moduleConfiguration = moduleConfig;
            return moduleConfiguration;
        }
    }

    protected static Context createXMapContext(final WebEngine engine) {
        return new Context(){
            private static final long serialVersionUID = 1L;

            public Class<?> loadClass(String className) throws ClassNotFoundException {
                return engine.getWebLoader().loadClass(className);
            }

            public URL getResource(String name) {
                return engine.getWebLoader().getResource(name);
            }
        };
    }
}

