/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.model.impl;

import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.webengine.loader.ClassProxy;
import org.nuxeo.ecm.webengine.loader.StaticClassProxy;
import org.nuxeo.ecm.webengine.model.Private;
import org.nuxeo.ecm.webengine.model.Protected;
import org.nuxeo.ecm.webengine.model.Public;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.AdapterDescriptor;

@XObject(value="web-object")
public class TypeDescriptor
implements Cloneable {
    public ClassProxy clazz;
    @XNode(value="@name")
    public String type;
    @XNode(value="@fragment")
    public String fragment;
    @XNode(value="@superType")
    public String superType = "*";
    public int visibility = 2;

    @XNode(value="@class")
    void setClassProxy(Class<?> clazz) {
        this.clazz = new StaticClassProxy(clazz);
    }

    @XNode(value="@visibility")
    public void setVisibility(String v) {
        switch (v) {
            case "public": {
                this.visibility = 3;
                break;
            }
            case "protected": {
                this.visibility = 1;
                break;
            }
            case "private": {
                this.visibility = 0;
                break;
            }
            default: {
                this.visibility = 2;
            }
        }
    }

    public TypeDescriptor() {
    }

    public TypeDescriptor(ClassProxy clazz, String type, String superType) {
        this.clazz = clazz;
        this.type = type;
        this.superType = superType;
        Class<?> k = clazz.get();
        if (k.isAnnotationPresent(Public.class)) {
            this.visibility = 3;
        } else if (k.isAnnotationPresent(Protected.class)) {
            this.visibility = 1;
        } else if (k.isAnnotationPresent(Private.class)) {
            this.visibility = 0;
        }
    }

    public int getVisibility() {
        return this.visibility;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.fragment == null ? 0 : this.fragment.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypeDescriptor)) {
            return false;
        }
        TypeDescriptor other = (TypeDescriptor)obj;
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.fragment == null ? other.fragment != null : !this.fragment.equals(other.fragment));
    }

    public TypeDescriptor clone() {
        try {
            return (TypeDescriptor)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Canot happen");
        }
    }

    public String getId() {
        return this.type;
    }

    public String getFragment() {
        return this.fragment;
    }

    public boolean isMainFragment() {
        return this.fragment == null;
    }

    public boolean isAdapter() {
        return false;
    }

    public AdapterDescriptor asAdapterDescriptor() {
        return null;
    }

    public TypeDescriptor asTypeDescriptor() {
        return this;
    }

    public static TypeDescriptor fromAnnotation(ClassProxy clazz, WebObject type) {
        return new TypeDescriptor(clazz, type.type(), type.superType());
    }

    public String toString() {
        return this.type + " extends " + this.superType + " [" + this.clazz.getClassName() + "]";
    }
}

