/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.model.io;

import jakarta.inject.Singleton;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.blobholder.DocumentBlobHolder;
import org.nuxeo.ecm.core.io.download.BufferingServletOutputStream;
import org.nuxeo.ecm.core.io.download.DownloadHelper;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

@Singleton
@Provider
@Produces(value={"*/*", "text/plain"})
public class DocumentBlobHolderWriter
implements MessageBodyWriter<DocumentBlobHolder> {
    @Context
    protected HttpServletRequest request;
    @Context
    protected HttpServletResponse response;

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return DocumentBlobHolder.class.isAssignableFrom(type);
    }

    public long getSize(DocumentBlobHolder blobHolder, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        long n = blobHolder.getBlob().getLength();
        return n < 0L ? -1L : n;
    }

    public void writeTo(DocumentBlobHolder blobHolder, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        this.commitAndReopenTransaction();
        Blob blob = blobHolder.getBlob();
        httpHeaders.clear();
        if (Framework.isTestModeSet()) {
            String filename = blob.getFilename();
            if (filename != null) {
                String contentDisposition = DownloadHelper.getRFC2231ContentDisposition((HttpServletRequest)this.request, (String)filename);
                this.response.setHeader("Content-Disposition", contentDisposition);
            }
            this.response.setContentType(blob.getMimeType());
            if (blob.getEncoding() != null) {
                try {
                    this.response.setCharacterEncoding(blob.getEncoding());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            this.transferBlob(blob, entityStream);
            return;
        }
        DownloadService.DownloadContext context = DownloadService.DownloadContext.builder((HttpServletRequest)this.request, (HttpServletResponse)this.response).doc(blobHolder.getDocument()).xpath(blobHolder.getXpath()).blob(blob).reason("download").build();
        ((DownloadService)Framework.getService(DownloadService.class)).downloadBlob(context);
    }

    protected void commitAndReopenTransaction() {
        if (TransactionHelper.isTransactionActiveOrMarkedRollback()) {
            TransactionHelper.commitOrRollbackTransaction();
            TransactionHelper.startTransaction();
        }
    }

    protected void transferBlob(Blob blob, OutputStream entityStream) throws IOException {
        if (entityStream instanceof BufferingServletOutputStream) {
            ((BufferingServletOutputStream)entityStream).stopBuffering();
        }
        blob.transferTo(entityStream);
        entityStream.flush();
    }
}

