/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.model.io;

import jakarta.inject.Singleton;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.nuxeo.ecm.core.api.blobholder.DownloadContextBlobHolder;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

@Singleton
@Provider
@Produces(value={"*/*", "text/plain"})
public class DownloadContextBlobHolderWriter
implements MessageBodyWriter<DownloadContextBlobHolder> {
    @Context
    protected HttpServletRequest request;
    @Context
    protected HttpServletResponse response;

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return DownloadContextBlobHolder.class.isAssignableFrom(type);
    }

    public long getSize(DownloadContextBlobHolder blobHolder, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        long n = blobHolder.getBlob().getLength();
        return n < 0L ? -1L : n;
    }

    public void writeTo(DownloadContextBlobHolder blobHolder, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        this.commitAndReopenTransaction();
        httpHeaders.clear();
        DownloadService.DownloadContext context = DownloadService.DownloadContext.builder((HttpServletRequest)this.request, (HttpServletResponse)this.response).doc(blobHolder.getDocument()).blob(blobHolder.getBlob()).filename(blobHolder.getFilename()).reason(blobHolder.getReason()).extendedInfos(blobHolder.getExtendedInfos()).inline(blobHolder.isInline()).lastModified(blobHolder.getModificationDate()).build();
        ((DownloadService)Framework.getService(DownloadService.class)).downloadBlob(context);
    }

    protected void commitAndReopenTransaction() {
        if (TransactionHelper.isTransactionActiveOrMarkedRollback()) {
            TransactionHelper.commitOrRollbackTransaction();
            TransactionHelper.startTransaction();
        }
    }
}

