/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.security;

import java.text.ParseException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.nuxeo.ecm.webengine.security.Guard;
import org.nuxeo.ecm.webengine.security.PostfixExpression;
import org.nuxeo.ecm.webengine.security.guards.And;
import org.nuxeo.ecm.webengine.security.guards.FacetGuard;
import org.nuxeo.ecm.webengine.security.guards.GroupGuard;
import org.nuxeo.ecm.webengine.security.guards.IsAdministratorGuard;
import org.nuxeo.ecm.webengine.security.guards.Not;
import org.nuxeo.ecm.webengine.security.guards.Or;
import org.nuxeo.ecm.webengine.security.guards.PermissionGuard;
import org.nuxeo.ecm.webengine.security.guards.SchemaGuard;
import org.nuxeo.ecm.webengine.security.guards.TypeGuard;
import org.nuxeo.ecm.webengine.security.guards.UserGuard;

public class PermissionService
implements PostfixExpression.Visitor {
    private static final PermissionService instance = new PermissionService();
    protected final ConcurrentMap<String, Guard> guards = new ConcurrentHashMap<String, Guard>();

    public static PermissionService getInstance() {
        return instance;
    }

    protected PermissionService() {
    }

    public void registerGuard(String name, Guard guard) {
        this.guards.put(name, guard);
    }

    public Guard unregisterGuard(String name) {
        return (Guard)this.guards.remove(name);
    }

    public Guard getGuard(String name) {
        return (Guard)this.guards.get(name);
    }

    public static Guard parse(String expr) throws ParseException {
        return (Guard)new PostfixExpression(expr).visit(instance);
    }

    public Guard parse(String expr, final Map<String, Guard> localGuards) throws ParseException {
        PostfixExpression.Visitor visitor = new PostfixExpression.Visitor(){

            @Override
            public Object createOperation(PostfixExpression.Token token, Object lparam, Object rparam) {
                return PermissionService.this.createOperation(token, lparam, rparam);
            }

            @Override
            public Object createParameter(PostfixExpression.Token token) {
                Guard guard = (Guard)localGuards.get(token.name);
                if (guard == null) {
                    return PermissionService.this.createParameter(token);
                }
                return guard;
            }
        };
        return (Guard)new PostfixExpression(expr).visit(visitor);
    }

    @Override
    public Object createOperation(PostfixExpression.Token token, Object lparam, Object rparam) {
        return switch (token.type) {
            case 2 -> new And((Guard)lparam, (Guard)rparam);
            case 3 -> new Or((Guard)lparam, (Guard)rparam);
            case 1 -> new Not((Guard)lparam);
            default -> throw new IllegalStateException("Supported ops are: AND, OR and NOT");
        };
    }

    @Override
    public Object createParameter(PostfixExpression.Token token) {
        String name = token.name;
        int p = name.indexOf(61);
        if (p > -1) {
            String key = name.substring(0, p).trim();
            String value = name.substring(p + 1).trim();
            return switch (key) {
                case "user" -> new UserGuard(value);
                case "group" -> new GroupGuard(value);
                case "isAdministrator" -> new IsAdministratorGuard(value);
                case "type" -> new TypeGuard(value);
                case "facet" -> new FacetGuard(value);
                case "schema" -> new SchemaGuard(value);
                case "permission" -> new PermissionGuard(value);
                default -> throw new IllegalArgumentException("Invalid argument: " + name);
            };
        }
        Guard guard = (Guard)this.guards.get(token.name);
        if (guard == null) {
            guard = new PermissionGuard(token.name);
        }
        return guard;
    }
}

