/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.model.Module;
import org.nuxeo.ecm.webengine.scripting.ScriptFile;
import org.nuxeo.runtime.api.Framework;

public class ResourceServlet
extends HttpServlet {
    private static final long serialVersionUID = 6548084847887645044L;
    private static final Logger log = LogManager.getLogger(ResourceServlet.class);

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        WebEngine engine = (WebEngine)Framework.getService(WebEngine.class);
        String path = req.getPathInfo();
        if (path == null) {
            resp.sendError(404);
            return;
        }
        int p = path.indexOf(47, 1);
        String moduleName = null;
        if (p <= -1) {
            resp.sendError(404);
            return;
        }
        moduleName = path.substring(1, p);
        path = path.substring(p);
        Module module = engine.getModule(moduleName);
        if (module == null) {
            resp.sendError(404);
            return;
        }
        try {
            this.service(req, resp, module, "/resources" + path);
        }
        catch (IOException e) {
            log.error("Unable to serve resource for: {}", (Object)path, (Object)e);
            resp.sendError(404);
        }
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp, Module module, String path) throws IOException {
        ScriptFile file = module.getSkinResource(path);
        if (file != null) {
            long lastModified = file.lastModified();
            resp.setDateHeader("Last-Modified", lastModified);
            resp.addHeader("Cache-Control", "public");
            resp.addHeader("Server", "Nuxeo/WebEngine-1.0");
            WebEngine engine = (WebEngine)Framework.getService(WebEngine.class);
            String mimeType = engine.getMimeType(file.getExtension());
            if (mimeType == null) {
                mimeType = "text/plain";
            }
            resp.setContentType(mimeType);
            if (mimeType.startsWith("text/")) {
                ResourceServlet.sendTextContent(file, resp);
            } else {
                ResourceServlet.sendBinaryContent(file, resp);
            }
            return;
        }
        resp.sendError(404);
    }

    protected static void sendBinaryContent(ScriptFile file, HttpServletResponse resp) throws IOException {
        ServletOutputStream out = resp.getOutputStream();
        try (InputStream in = file.getInputStream();){
            IOUtils.copy((InputStream)in, (OutputStream)out);
            out.flush();
        }
    }

    protected static void sendTextContent(ScriptFile file, HttpServletResponse resp) throws IOException {
        ServletOutputStream out = resp.getOutputStream();
        try (InputStream in = file.getInputStream();){
            IOUtils.copy((InputStream)in, (OutputStream)out);
            out.flush();
        }
    }
}

