/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api;

import java.io.Serializable;
import java.lang.runtime.SwitchBootstraps;
import java.text.Collator;
import java.util.Calendar;
import java.util.Map;
import java.util.Objects;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.Sorter;

public class DocumentModelComparator
implements Sorter {
    private static final long serialVersionUID = 1L;
    public static final String ORDER_ASC = "asc";
    static final Collator collator = Collator.getInstance();
    final String schemaName;
    final Map<String, String> orderBy;

    public DocumentModelComparator(String schemaName, Map<String, String> orderBy) {
        this.schemaName = schemaName;
        this.orderBy = orderBy;
    }

    public DocumentModelComparator(Map<String, String> orderBy) {
        this(null, orderBy);
    }

    protected int compare(Object v1, Object v2, boolean asc) {
        int n;
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v1 == null) {
            return asc ? -1 : 1;
        }
        if (v2 == null) {
            return asc ? 1 : -1;
        }
        Object object = v1;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n2 = 0;
        block5: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Long.class, Integer.class, Calendar.class}, (Object)object2, n2)) {
                case 0: {
                    Long l1 = (Long)object2;
                    if (!(v2 instanceof Long)) {
                        n2 = 1;
                        continue block5;
                    }
                    Long l2 = (Long)v2;
                    n = l1.compareTo(l2);
                    break block5;
                }
                case 1: {
                    Integer i1 = (Integer)object2;
                    if (!(v2 instanceof Integer)) {
                        n2 = 2;
                        continue block5;
                    }
                    Integer i2 = (Integer)v2;
                    n = i1.compareTo(i2);
                    break block5;
                }
                case 2: {
                    Calendar c1 = (Calendar)object2;
                    if (!(v2 instanceof Calendar)) {
                        n2 = 3;
                        continue block5;
                    }
                    Calendar c2 = (Calendar)v2;
                    n = c1.compareTo(c2);
                    break block5;
                }
                default: {
                    n = collator.compare(v1.toString(), v2.toString());
                    break block5;
                }
            }
            break;
        }
        int cmp = n;
        return asc ? cmp : -cmp;
    }

    @Override
    public int compare(DocumentModel doc1, DocumentModel doc2) {
        if (doc1 == null && doc2 == null) {
            return 0;
        }
        if (doc1 == null) {
            return -1;
        }
        if (doc2 == null) {
            return 1;
        }
        int cmp = 0;
        if (this.schemaName != null) {
            DataModel d1 = doc1.getDataModel(this.schemaName);
            DataModel d2 = doc2.getDataModel(this.schemaName);
            for (Map.Entry<String, String> e : this.orderBy.entrySet()) {
                Object v2;
                String fieldName = e.getKey();
                boolean asc = ORDER_ASC.equals(e.getValue());
                Object v1 = d1.getData(fieldName);
                cmp = this.compare(v1, v2 = d2.getData(fieldName), asc);
                if (cmp == 0) continue;
                break;
            }
        } else {
            for (Map.Entry<String, String> e : this.orderBy.entrySet()) {
                Serializable v2;
                Serializable v1;
                String propertyName = e.getKey();
                boolean asc = ORDER_ASC.equals(e.getValue());
                try {
                    v1 = doc1.getPropertyValue(propertyName);
                }
                catch (PropertyException pe) {
                    v1 = null;
                }
                try {
                    v2 = doc2.getPropertyValue(propertyName);
                }
                catch (PropertyException pe) {
                    v2 = null;
                }
                if ((cmp = this.compare(v1, v2, asc)) == 0) continue;
                break;
            }
        }
        if (cmp == 0) {
            cmp = Integer.compare(doc1.hashCode(), doc2.hashCode());
        }
        return cmp;
    }

    static {
        collator.setStrength(0);
    }
}

