/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.adapter;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.adapter.DocumentAdapterDescriptor;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

public class DocumentAdapterService
extends DefaultComponent {
    private static final Logger log = LogManager.getLogger(DocumentAdapterService.class);
    public static final ComponentName NAME = new ComponentName("service", "org.nuxeo.ecm.core.api.DocumentAdapterService");
    protected Map<Class<?>, DocumentAdapterDescriptor> adapters;

    public DocumentAdapterDescriptor getAdapterDescriptor(Class<?> itf) {
        return this.adapters.get(itf);
    }

    public DocumentAdapterDescriptor[] getAdapterDescriptors() {
        Collection<DocumentAdapterDescriptor> values = this.adapters.values();
        return (DocumentAdapterDescriptor[])values.toArray(DocumentAdapterDescriptor[]::new);
    }

    public void registerAdapterFactory(DocumentAdapterDescriptor dae) {
        this.adapters.put(dae.getInterface(), dae);
        log.info("Registered document adapter factory: {}", (Object)dae);
    }

    public void unregisterAdapterFactory(Class<?> itf) {
        DocumentAdapterDescriptor dae = this.adapters.remove(itf);
        if (dae != null) {
            log.info("Unregistered document adapter factory: {}", (Object)dae);
        }
    }

    public void activate(ComponentContext context) {
        this.adapters = new ConcurrentHashMap();
    }

    public void deactivate(ComponentContext context) {
        this.adapters.clear();
        this.adapters = null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals("adapters")) {
            DocumentAdapterDescriptor dae = (DocumentAdapterDescriptor)contribution;
            this.registerAdapterFactory(dae);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals("adapters")) {
            DocumentAdapterDescriptor dae = (DocumentAdapterDescriptor)contribution;
            this.unregisterAdapterFactory(dae.getInterface());
        }
    }
}

