/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.repository;

import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;

@XObject(value="pool")
public class PoolConfiguration {
    public static final int DEFAULT_MAX_POOL_SIZE = 20;
    public static final int DEFAULT_MIN_POOL_SIZE = 0;
    public static final int DEFAULT_BLOCKING_TIMEOUT_MILLIS = 100;
    @XNode(value="@maxPoolSize")
    private Integer maxPoolSize;
    @XNode(value="@minPoolSize")
    private Integer minPoolSize;
    @XNode(value="@blockingTimeoutMillis")
    private Integer blockingTimeoutMillis;

    public PoolConfiguration() {
    }

    public PoolConfiguration(PoolConfiguration other) {
        this.maxPoolSize = other.maxPoolSize;
        this.minPoolSize = other.minPoolSize;
        this.blockingTimeoutMillis = other.blockingTimeoutMillis;
    }

    public void merge(PoolConfiguration other) {
        if (other.maxPoolSize != null) {
            this.maxPoolSize = other.maxPoolSize;
        }
        if (other.minPoolSize != null) {
            this.minPoolSize = other.minPoolSize;
        }
        if (other.blockingTimeoutMillis != null) {
            this.blockingTimeoutMillis = other.blockingTimeoutMillis;
        }
    }

    private static int defaultInt(Integer value, int def) {
        return value == null ? def : value;
    }

    public int getMaxPoolSize() {
        return PoolConfiguration.defaultInt(this.maxPoolSize, 20);
    }

    public int getMinPoolSize() {
        return PoolConfiguration.defaultInt(this.minPoolSize, 0);
    }

    public int getBlockingTimeoutMillis() {
        return PoolConfiguration.defaultInt(this.blockingTimeoutMillis, 100);
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public void setMinPoolSize(int minPoolSize) {
        this.minPoolSize = minPoolSize;
    }

    public void setBlockingTimeoutMillis(int blockingTimeoutMillis) {
        this.blockingTimeoutMillis = blockingTimeoutMillis;
    }

    @XNode(value="@maxActive")
    public void setMaxActive(int num) {
        this.maxPoolSize = num;
    }

    @XNode(value="@maxIdle")
    public void setMaxIdle(int num) {
        this.minPoolSize = num;
    }

    @XNode(value="@maxWait")
    public void setMaxWait(int num) {
        this.blockingTimeoutMillis = num;
    }
}

