/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class RepositoryManagerImpl
extends DefaultComponent
implements RepositoryManager {
    private static final Logger log = LogManager.getLogger(RepositoryManagerImpl.class);
    private Map<String, Repository> repositories = Collections.synchronizedMap(new LinkedHashMap());
    private Map<String, Repository> compatRepositories = new ConcurrentHashMap<String, Repository>();
    private static final String XP_REPOSITORIES = "repositories";

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (!XP_REPOSITORIES.equals(extensionPoint)) {
            throw new RuntimeException("Unknown extension point: " + extensionPoint);
        }
        Repository repo = (Repository)contribution;
        log.warn("Using old-style extension point org.nuxeo.ecm.core.api.repository.RepositoryManager for repository: \"{}\", use org.nuxeo.ecm.core.storage.sql.RepositoryService instead", (Object)repo.getName());
        this.compatRepositories.put(repo.getName(), repo);
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (!XP_REPOSITORIES.equals(extensionPoint)) {
            throw new RuntimeException("Unknown extension point: " + extensionPoint);
        }
        Repository repo = (Repository)contribution;
        this.compatRepositories.remove(repo.getName());
    }

    @Override
    public void addRepository(Repository repository) {
        String name = repository.getName();
        if (this.repositories.containsKey(name)) {
            log.info("Overriding repository: {}", (Object)name);
        } else {
            log.info("Registering repository: {}", (Object)name);
        }
        Repository compat = this.compatRepositories.get(name);
        if (compat != null) {
            if (repository.getLabel() == null) {
                repository.setLabel(compat.getLabel());
            }
            if (repository.getDefault() != null) {
                repository.setDefault(compat.getDefault());
            }
        }
        this.repositories.put(name, repository);
    }

    @Override
    public void removeRepository(String name) {
        log.info("Removing repository: {}", (Object)name);
        this.repositories.remove(name);
    }

    @Override
    public Collection<Repository> getRepositories() {
        return new ArrayList<Repository>(this.repositories.values());
    }

    @Override
    public List<String> getRepositoryNames() {
        return new ArrayList<String>(this.repositories.keySet());
    }

    @Override
    public Repository getRepository(String name) {
        return this.repositories.get(name);
    }

    @Override
    public Repository getDefaultRepository() {
        for (Repository repository : this.repositories.values()) {
            if (repository.isDefault()) {
                return repository;
            }
            if (!"default".equals(repository.getName())) continue;
            return repository;
        }
        if (!this.repositories.isEmpty()) {
            return this.repositories.values().iterator().next();
        }
        throw new RuntimeException("No repository defined");
    }

    @Override
    public String getDefaultRepositoryName() {
        return this.getDefaultRepository().getName();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (RepositoryManager.class.isAssignableFrom(adapter)) {
            return (T)this;
        }
        return null;
    }
}

