/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.security.impl;

import java.util.HashSet;
import java.util.Set;
import org.nuxeo.ecm.core.api.security.UserEntry;

public class UserEntryImpl
implements UserEntry {
    private static final long serialVersionUID = 1L;
    private final String username;
    private final Set<String> granted;
    private final Set<String> denied;

    public UserEntryImpl(String username) {
        this.username = username;
        this.granted = new HashSet<String>();
        this.denied = new HashSet<String>();
    }

    @Override
    public void addPrivilege(String permission) {
        this.granted.add(permission);
        this.denied.remove(permission);
    }

    @Override
    public void addPrivilege(String permission, boolean isGranted) {
        if (isGranted) {
            this.addPrivilege(permission);
        } else {
            this.granted.remove(permission);
            this.denied.add(permission);
        }
    }

    @Override
    public String getUserName() {
        return this.username;
    }

    @Override
    public Set<String> getGrantedPermissions() {
        return this.granted;
    }

    @Override
    public Set<String> getDeniedPermissions() {
        return this.denied;
    }
}

