/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.thumbnail;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.thumbnail.ThumbnailFactory;
import org.nuxeo.ecm.core.api.thumbnail.ThumbnailFactoryDescriptor;
import org.nuxeo.ecm.core.api.thumbnail.ThumbnailService;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class ThumbnailServiceImpl
extends DefaultComponent
implements ThumbnailService {
    private static final Logger log = LogManager.getLogger(ThumbnailServiceImpl.class);
    public static final String THUMBNAILFACTORY_EP = "thumbnailFactory";
    protected ThumbnailFactory defaultFactory;
    protected final Map<String, ThumbnailFactory> factoriesByDocType = new HashMap<String, ThumbnailFactory>();
    protected final Map<String, ThumbnailFactory> factoriesByFacets = new HashMap<String, ThumbnailFactory>();

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (THUMBNAILFACTORY_EP.equals(extensionPoint)) {
            String facet;
            ThumbnailFactoryDescriptor desc = (ThumbnailFactoryDescriptor)contribution;
            String docType = desc.getDocType();
            if (docType != null) {
                this.factoriesByDocType.put(docType, desc.getFactory());
            }
            if ((facet = desc.getFacet()) != null) {
                this.factoriesByFacets.put(facet, desc.getFactory());
            }
            if (docType == null && facet == null) {
                this.defaultFactory = desc.getFactory();
            }
        } else {
            log.error("Unknown extension point: {}", (Object)extensionPoint);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
    }

    public Set<String> getFactoryByDocTypeNames() {
        return this.factoriesByDocType.keySet();
    }

    public Set<String> getFactoryByFacetNames() {
        return this.factoriesByFacets.keySet();
    }

    public ThumbnailFactory getDefaultFactory() {
        return this.defaultFactory;
    }

    @Override
    public Blob getThumbnail(DocumentModel doc, CoreSession session) {
        ThumbnailFactory factory = this.getThumbnailFactory(doc, session);
        return factory.getThumbnail(doc, session);
    }

    @Override
    public Blob computeThumbnail(DocumentModel doc, CoreSession session) {
        ThumbnailFactory factory = this.getThumbnailFactory(doc, session);
        return factory.computeThumbnail(doc, session);
    }

    public ThumbnailFactory getThumbnailFactory(DocumentModel doc, CoreSession session) {
        if (this.factoriesByDocType.containsKey(doc.getType())) {
            ThumbnailFactory factory = this.factoriesByDocType.get(doc.getType());
            return factory;
        }
        for (Map.Entry<String, ThumbnailFactory> entry : this.factoriesByFacets.entrySet()) {
            if (!doc.hasFacet(entry.getKey())) continue;
            return entry.getValue();
        }
        if (this.defaultFactory == null) {
            throw new NuxeoException("Please contribute a default thumbnail factory");
        }
        return this.defaultFactory;
    }
}

