/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.runtime.model.Descriptor;

@XObject(value="blobprovider")
public class BlobProviderDescriptor
implements Descriptor {
    public static final String PREVENT_USER_UPDATE = "preventUserUpdate";
    public static final String NAMESPACE = "namespace";
    public static final String TRANSIENT = "transient";
    public static final String COLD_STORAGE = "coldStorage";
    public static final String RECORD = "record";
    public static final String TRANSACTIONAL = "transactional";
    public static final String ALLOW_BYTE_RANGE = "allowByteRange";
    public static final String DIRECTDOWNLOAD_PROPERTY = "directdownload";
    public static final String DIRECTDOWNLOAD_EXPIRE_PROPERTY = "directdownload.expire";
    public static final String CREATE_FROM_KEY_USERS = "createFromKey.users";
    public static final String CREATE_FROM_KEY_GROUPS = "createFromKey.groups";
    @XNode(value="@name")
    public String name = "";
    @XNode(value="class")
    public Class<?> klass;
    @XNodeMap(value="property", key="@name", type=HashMap.class, componentType=String.class)
    public Map<String, String> properties = new HashMap<String, String>();

    public BlobProviderDescriptor() {
    }

    public BlobProviderDescriptor(BlobProviderDescriptor other) {
        this.name = other.name;
        this.klass = other.klass;
        this.properties = new HashMap<String, String>(other.properties);
    }

    public String getId() {
        return this.name;
    }

    public BlobProviderDescriptor merge(Descriptor o) {
        BlobProviderDescriptor other = (BlobProviderDescriptor)o;
        BlobProviderDescriptor merged = new BlobProviderDescriptor();
        merged.name = this.name;
        merged.klass = (Class)ObjectUtils.defaultIfNull(other.klass, this.klass);
        merged.properties.putAll(this.properties);
        merged.properties.putAll(other.properties);
        return merged;
    }
}

