/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import org.nuxeo.ecm.core.blob.BlobContext;
import org.nuxeo.ecm.core.blob.BlobUpdateContext;
import org.nuxeo.ecm.core.blob.BlobWriteContext;
import org.nuxeo.ecm.core.blob.KeyStrategy;
import org.nuxeo.ecm.core.blob.binary.BinaryGarbageCollector;

public interface BlobStore {
    public String getName();

    public boolean hasVersioning();

    public KeyStrategy getKeyStrategy();

    public String writeBlob(BlobContext var1) throws IOException;

    public String writeBlob(BlobWriteContext var1) throws IOException;

    public boolean copyBlobIsOptimized(BlobStore var1);

    @Deprecated
    default public boolean copyBlob(String key, BlobStore sourceStore, String sourceKey, boolean atomicMove) throws IOException {
        return this.copyOrMoveBlob(key, sourceStore, sourceKey, atomicMove) != null;
    }

    public String copyOrMoveBlob(String var1, BlobStore var2, String var3, boolean var4) throws IOException;

    @NotNull
    public OptionalOrUnknown<Path> getFile(String var1);

    @NotNull
    public OptionalOrUnknown<InputStream> getStream(String var1) throws IOException;

    public boolean readBlob(String var1, Path var2) throws IOException;

    public void writeBlobProperties(BlobUpdateContext var1) throws IOException;

    public void deleteBlob(BlobContext var1);

    public void deleteBlob(String var1);

    default public boolean exists(String key) {
        BlobStore unwrapped = this.unwrap();
        if (unwrapped == this) {
            return false;
        }
        return unwrapped.exists(key);
    }

    default public boolean hasDefaultStorageClass(String key) {
        BlobStore unwrapped = this.unwrap();
        if (unwrapped == this) {
            return false;
        }
        return unwrapped.hasDefaultStorageClass(key);
    }

    public BinaryGarbageCollector getBinaryGarbageCollector();

    public BlobStore unwrap();

    public void clear();

    public static class OptionalOrUnknown<T> {
        private static final OptionalOrUnknown<?> UNKNOWN = new OptionalOrUnknown();
        private static final OptionalOrUnknown<?> MISSING = new OptionalOrUnknown<Object>(null);
        private Optional<T> value;

        private OptionalOrUnknown() {
            this.value = null;
        }

        private OptionalOrUnknown(T value) {
            this.value = value == null ? Optional.empty() : Optional.of(value);
        }

        public static <T> OptionalOrUnknown<T> unknown() {
            OptionalOrUnknown<?> t = UNKNOWN;
            return t;
        }

        public static <T> OptionalOrUnknown<T> missing() {
            OptionalOrUnknown<?> t = MISSING;
            return t;
        }

        public static <T> OptionalOrUnknown<T> of(T value) {
            return new OptionalOrUnknown<T>(Objects.requireNonNull(value));
        }

        public boolean isUnknown() {
            return this.value == null;
        }

        public boolean isKnown() {
            return this.value != null;
        }

        public boolean isPresent() {
            return this.value != null && this.value.isPresent();
        }

        public boolean isMissing() {
            return this.value != null && !this.value.isPresent();
        }

        @NotNull
        public T get() {
            if (this.value == null || !this.value.isPresent()) {
                throw new NoSuchElementException("No value known and present");
            }
            return this.value.get();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof OptionalOrUnknown)) {
                return false;
            }
            OptionalOrUnknown other = (OptionalOrUnknown)obj;
            return Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            return Objects.hashCode(this.value);
        }
    }
}

