/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import java.io.IOException;
import java.util.Map;
import org.nuxeo.ecm.core.blob.AbstractBlobStore;
import org.nuxeo.ecm.core.blob.BlobStore;
import org.nuxeo.ecm.core.blob.BlobStoreBlobProvider;
import org.nuxeo.ecm.core.blob.CachingBlobStore;
import org.nuxeo.ecm.core.blob.CachingConfiguration;
import org.nuxeo.ecm.core.blob.DigestConfiguration;
import org.nuxeo.ecm.core.blob.InMemoryBlobStore;
import org.nuxeo.ecm.core.blob.KeyStrategy;
import org.nuxeo.ecm.core.blob.PropertyBasedConfiguration;
import org.nuxeo.ecm.core.blob.TransactionalBlobStore;

public class InMemoryBlobProvider
extends BlobStoreBlobProvider {
    public static final String STORE_SCROLL_NAME = "inMemoryBlobScroll";
    protected DigestConfiguration digestConfiguration;

    @Override
    protected BlobStore getBlobStore(String blobProviderId, Map<String, String> properties) throws IOException {
        this.digestConfiguration = new DigestConfiguration(null, properties);
        PropertyBasedConfiguration config = new PropertyBasedConfiguration(null, properties);
        KeyStrategy keyStrategy = this.getKeyStrategy();
        AbstractBlobStore store = new InMemoryBlobStore("mem", config, keyStrategy, false, config.getBooleanProperty("emulateLocalFile"));
        if (this.isTransactional()) {
            AbstractBlobStore transientStore = store.hasVersioning() ? store : new InMemoryBlobStore("mem_tmp", keyStrategy);
            store = new TransactionalBlobStore(blobProviderId, store, transientStore);
        }
        if (config.getBooleanProperty("test-caching")) {
            CachingConfiguration cachingConfiguration = new CachingConfiguration(null, properties);
            store = new CachingBlobStore(blobProviderId, "Cache", store, cachingConfiguration);
        }
        return store;
    }

    @Override
    public void close() {
    }

    @Override
    protected String getDigestAlgorithm() {
        return this.digestConfiguration.digestAlgorithm;
    }

    @Override
    public String getStoreScrollName() {
        return STORE_SCROLL_NAME;
    }
}

