/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.blob.AbstractBlobStore;
import org.nuxeo.ecm.core.blob.BlobStore;
import org.nuxeo.ecm.core.blob.BlobWriteContext;
import org.nuxeo.ecm.core.blob.KeyStrategy;
import org.nuxeo.ecm.core.blob.KeyStrategyDigest;
import org.nuxeo.ecm.core.blob.PathStrategy;
import org.nuxeo.ecm.core.blob.binary.BinaryGarbageCollector;
import org.nuxeo.ecm.core.blob.binary.BinaryManagerStatus;

public class LocalBlobStore
extends AbstractBlobStore {
    private static final Logger log = LogManager.getLogger(LocalBlobStore.class);
    protected final PathStrategy pathStrategy;
    protected final LocalBlobGarbageCollector gc;

    public LocalBlobStore(String name, KeyStrategy keyStrategy, PathStrategy pathStrategy) {
        super(name, keyStrategy);
        this.pathStrategy = pathStrategy;
        this.gc = new LocalBlobGarbageCollector();
    }

    public Path getDirectory() {
        return this.pathStrategy.dir;
    }

    public PathStrategy getPathStrategy() {
        return this.pathStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String writeBlobGeneric(BlobWriteContext blobWriteContext) throws IOException {
        Path tmp = this.pathStrategy.createTempFile();
        try {
            this.write(blobWriteContext, tmp);
            this.logTrace("->", "write " + Files.size(tmp) + " bytes");
            this.logTrace("hnote right: " + tmp.getFileName().toString());
            String key = blobWriteContext.getKey();
            Path dest = this.pathStrategy.getPathForKey(key);
            Files.createDirectories(dest.getParent(), new FileAttribute[0]);
            this.logTrace(this.name, "-->", this.name, "rename");
            this.logTrace("hnote right of " + this.name + ": " + key);
            PathStrategy.atomicMove(tmp, dest);
            String string = key;
            return string;
        }
        finally {
            try {
                Files.deleteIfExists(tmp);
            }
            catch (IOException e) {
                log.warn((Object)e, (Throwable)e);
            }
        }
    }

    protected void write(BlobWriteContext blobWriteContext, Path file) throws IOException {
        this.transfer(blobWriteContext, file);
    }

    @Override
    public boolean copyBlobIsOptimized(BlobStore sourceStore) {
        return sourceStore.unwrap() instanceof LocalBlobStore;
    }

    @Override
    public String copyOrMoveBlob(String key, BlobStore sourceStore, String sourceKey, boolean atomicMove) throws IOException {
        BlobStore unwrappedSourceStore = sourceStore.unwrap();
        if (unwrappedSourceStore instanceof LocalBlobStore) {
            LocalBlobStore sourceLocalBlobStore = (LocalBlobStore)unwrappedSourceStore;
            return this.copyBlob(key, sourceLocalBlobStore, sourceKey, atomicMove);
        }
        return this.copyBlobGeneric(key, sourceStore, sourceKey, atomicMove);
    }

    protected String copyBlob(String key, LocalBlobStore sourceStore, String sourceKey, boolean atomicMove) throws IOException {
        Path source = sourceStore.pathStrategy.getPathForKey(sourceKey);
        if (!Files.exists(source, new LinkOption[0])) {
            return null;
        }
        if (key == null) {
            String digestAlgorithm = ((KeyStrategyDigest)this.keyStrategy).digestAlgorithm;
            key = new DigestUtils(digestAlgorithm).digestAsHex(source.toFile());
        }
        Path dest = this.pathStrategy.getPathForKey(key);
        Files.createDirectories(dest.getParent(), new FileAttribute[0]);
        if (atomicMove) {
            if (sourceStore == this) {
                this.logTrace("hnote right of " + this.name + ": " + sourceKey);
                this.logTrace(this.name, "-->", this.name, "rename");
                this.logTrace("hnote right of " + this.name + ": " + key);
            } else {
                this.logTrace("hnote right of " + sourceStore.name + ": " + sourceKey);
                this.logTrace(sourceStore.name, "->", this.name, "move");
                this.logTrace("hnote right: " + key);
            }
            PathStrategy.atomicMove(source, dest);
        } else {
            this.logTrace("hnote right of " + sourceStore.name + ": " + sourceKey);
            this.logTrace(sourceStore.name, "->", this.name, "copy");
            this.logTrace("hnote right: " + key);
            PathStrategy.atomicCopy(source, dest);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String copyBlobGeneric(String key, BlobStore sourceStore, String sourceKey, boolean atomicMove) throws IOException {
        Path dest = this.pathStrategy.getPathForKey(key);
        Files.createDirectories(dest.getParent(), new FileAttribute[0]);
        Path tmp = null;
        try {
            Path readTo = atomicMove ? (tmp = this.pathStrategy.createTempFile()) : dest;
            BlobStore.OptionalOrUnknown<Path> fileOpt = sourceStore.getFile(sourceKey);
            if (fileOpt.isPresent()) {
                PathStrategy.atomicCopy(fileOpt.get(), readTo);
            } else {
                boolean found = sourceStore.readBlob(sourceKey, readTo);
                if (!found) {
                    String string = null;
                    return string;
                }
            }
            if (atomicMove) {
                PathStrategy.atomicMove(readTo, dest);
                sourceStore.deleteBlob(sourceKey);
            }
            String string = key;
            return string;
        }
        finally {
            if (tmp != null) {
                try {
                    Files.deleteIfExists(tmp);
                }
                catch (IOException e) {
                    log.warn((Object)e, (Throwable)e);
                }
            }
        }
    }

    @Override
    public BlobStore.OptionalOrUnknown<Path> getFile(String key) {
        return this.getStoredFile(key);
    }

    protected BlobStore.OptionalOrUnknown<Path> getStoredFile(String key) {
        Path file = this.pathStrategy.getPathForKey(key);
        return Files.exists(file, new LinkOption[0]) ? BlobStore.OptionalOrUnknown.of(file) : BlobStore.OptionalOrUnknown.missing();
    }

    @Override
    public BlobStore.OptionalOrUnknown<InputStream> getStream(String key) throws IOException {
        Path file = this.pathStrategy.getPathForKey(key);
        try {
            return BlobStore.OptionalOrUnknown.of(new BufferedInputStream(Files.newInputStream(file, new OpenOption[0])));
        }
        catch (NoSuchFileException e) {
            return BlobStore.OptionalOrUnknown.missing();
        }
    }

    @Override
    public boolean readBlob(String key, Path dest) throws IOException {
        Path file = this.pathStrategy.getPathForKey(key);
        if (Files.exists(file, new LinkOption[0])) {
            this.logTrace("<-", "read " + Files.size(file) + " bytes");
            this.logTrace("hnote right: " + key);
            PathStrategy.atomicCopy(file, dest);
            return true;
        }
        this.logTrace("<--", "missing");
        this.logTrace("hnote right: " + key);
        return false;
    }

    @Override
    public void deleteBlob(String key) {
        Path file = this.pathStrategy.getPathForKey(key);
        try {
            this.logTrace("->", "delete");
            this.logTrace("hnote right: " + key);
            Files.deleteIfExists(file);
        }
        catch (IOException e) {
            log.warn((Object)e, (Throwable)e);
        }
    }

    @Override
    public boolean exists(String key) {
        Path file = this.pathStrategy.getPathForKey(key);
        return Files.exists(file, new LinkOption[0]);
    }

    @Override
    public void clear() {
        try {
            FileUtils.cleanDirectory((File)this.pathStrategy.dir.toFile());
        }
        catch (IOException e) {
            log.warn((Object)e, (Throwable)e);
        }
    }

    @Override
    public BinaryGarbageCollector getBinaryGarbageCollector() {
        return this.gc;
    }

    public class LocalBlobGarbageCollector
    implements BinaryGarbageCollector {
        public static final long TIME_RESOLUTION = 2000L;
        protected volatile long startTime;
        protected BinaryManagerStatus status;
        public volatile boolean markInMemory;
        protected Set<String> toDelete;

        @Override
        public String getId() {
            return LocalBlobStore.this.pathStrategy.dir.toUri().toString();
        }

        @Override
        public BinaryManagerStatus getStatus() {
            return this.status;
        }

        @Override
        public boolean isInProgress() {
            return this.startTime != 0L;
        }

        @Override
        public void start() {
            if (this.startTime != 0L) {
                throw new NuxeoException("Already started");
            }
            this.startTime = System.currentTimeMillis();
            this.status = new BinaryManagerStatus();
            if (this.markInMemory) {
                this.toDelete = new HashSet<String>();
                this.computeToDelete(LocalBlobStore.this.pathStrategy.dir.toFile(), this.startTime - 2000L);
            }
        }

        protected void computeToDelete(File file, long minTime) {
            if (file.isDirectory()) {
                for (File f : file.listFiles()) {
                    this.computeToDelete(f, minTime);
                }
            } else if (file.isFile() && file.canWrite()) {
                long lastModified = file.lastModified();
                if (lastModified == 0L) {
                    log.warn("GC cannot read last modified for file: {}", (Object)file);
                } else if (lastModified < minTime) {
                    this.status.sizeBinaries += file.length();
                    ++this.status.numBinaries;
                    this.toDelete.add(file.getName());
                }
            }
        }

        @Override
        public void mark(String key) {
            if (this.markInMemory) {
                this.toDelete.remove(key);
            } else {
                BlobStore.OptionalOrUnknown<Path> fileOpt = LocalBlobStore.this.getStoredFile(key);
                if (!fileOpt.isPresent()) {
                    log.trace("Unknown blob for key: {}", (Object)key);
                    return;
                }
                this.touch(fileOpt.get().toFile());
            }
        }

        @Override
        public void stop(boolean delete) {
            if (this.startTime == 0L) {
                throw new NuxeoException("Not started");
            }
            if (this.markInMemory) {
                this.removeUnmarkedBlobsAndUpdateStatus(delete);
            } else {
                this.deleteOld(LocalBlobStore.this.pathStrategy.dir.toFile(), this.startTime - 2000L, 0, delete);
            }
            this.status.gcDuration = System.currentTimeMillis() - this.startTime;
            this.startTime = 0L;
            this.toDelete = null;
        }

        protected void removeUnmarkedBlobsAndUpdateStatus(boolean delete) {
            for (String key : this.toDelete) {
                long length;
                BlobStore.OptionalOrUnknown<Path> fileOpt = LocalBlobStore.this.getStoredFile(key);
                if (!fileOpt.isPresent()) continue;
                Path path = fileOpt.get();
                try {
                    length = Files.size(path);
                }
                catch (IOException e) {
                    log.error(key, (Throwable)e);
                    continue;
                }
                this.status.sizeBinariesGC += length;
                ++this.status.numBinariesGC;
                this.status.sizeBinaries -= length;
                --this.status.numBinaries;
                if (!delete) continue;
                try {
                    Files.delete(path);
                }
                catch (IOException e) {
                    log.error(key, (Throwable)e);
                }
            }
        }

        protected void deleteOld(File file, long minTime, int depth, boolean delete) {
            if (file.isDirectory()) {
                for (File f : file.listFiles()) {
                    this.deleteOld(f, minTime, depth + 1, delete);
                }
            } else if (file.isFile() && file.canWrite()) {
                long lastModified = file.lastModified();
                long length = file.length();
                if (lastModified == 0L) {
                    log.warn("GC cannot read last modified for file: {}", (Object)file);
                } else if (lastModified < minTime) {
                    this.status.sizeBinariesGC += length;
                    ++this.status.numBinariesGC;
                    if (delete) {
                        log.debug("GC deleting file: {}", (Object)file);
                        if (!file.delete()) {
                            log.warn("GC failed to delete file: {}", (Object)file);
                        }
                    }
                } else {
                    this.status.sizeBinaries += length;
                    ++this.status.numBinaries;
                }
            }
        }

        protected void touch(File file) {
            long time = System.currentTimeMillis();
            if (file.setLastModified(time)) {
                return;
            }
            if (!file.canWrite()) {
                return;
            }
            try (RandomAccessFile r = new RandomAccessFile(file, "rw");){
                r.setLength(r.length());
            }
            catch (IOException e) {
                log.warn("Cannot set last modified for file: " + String.valueOf(file), (Throwable)e);
            }
        }
    }
}

