/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob.binary;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.DownloadBlobGuard;
import org.nuxeo.ecm.core.blob.BlobInfo;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.core.blob.binary.AbstractBinaryManager;
import org.nuxeo.ecm.core.blob.binary.Binary;
import org.nuxeo.ecm.core.blob.binary.BinaryBlob;
import org.nuxeo.ecm.core.blob.binary.BinaryGarbageCollector;
import org.nuxeo.ecm.core.blob.binary.BinaryManager;
import org.nuxeo.ecm.core.blob.binary.LazyBinary;

@Deprecated(since="2023.9")
public class BinaryBlobProvider
implements BlobProvider {
    private static final Logger log = LogManager.getLogger(BinaryBlobProvider.class);
    protected final BinaryManager binaryManager;
    protected boolean supportsUserUpdate;
    protected boolean transientFlag;

    public BinaryBlobProvider(BinaryManager binaryManager) {
        this.binaryManager = binaryManager;
    }

    @Override
    public BinaryGarbageCollector getBinaryGarbageCollector() {
        BinaryManager binaryManager = this.getBinaryManager();
        return binaryManager == null ? null : binaryManager.getGarbageCollector();
    }

    @Override
    public void initialize(String blobProviderId, Map<String, String> properties) throws IOException {
        this.binaryManager.initialize(blobProviderId, properties);
        this.supportsUserUpdate = this.supportsUserUpdateDefaultTrue(properties);
        this.transientFlag = Boolean.parseBoolean(properties.get("transient"));
    }

    @Override
    public boolean supportsUserUpdate() {
        return this.supportsUserUpdate;
    }

    protected boolean supportsUserUpdateDefaultTrue(Map<String, String> properties) {
        return !Boolean.parseBoolean(properties.get("preventUserUpdate"));
    }

    @Override
    public boolean isTransient() {
        return this.transientFlag;
    }

    @Override
    public void close() {
        this.binaryManager.close();
    }

    @Override
    public BinaryManager getBinaryManager() {
        return this.binaryManager;
    }

    protected String stripBlobKeyPrefix(String key) {
        int colon = key.indexOf(58);
        if (colon >= 0) {
            key = key.substring(colon + 1);
        }
        return key;
    }

    @Override
    public Blob readBlob(BlobInfo blobInfo) throws IOException {
        long length;
        String digest = this.stripBlobKeyPrefix(blobInfo.key);
        Binary binary = this.binaryManager.getBinary(digest);
        if (binary == null) {
            throw new IOException("Unknown binary: " + digest);
        }
        if (blobInfo.length != null) {
            length = blobInfo.length;
        } else if (DownloadBlobGuard.isEnable()) {
            length = -1L;
        } else {
            log.info("Missing content length for blob key: {}, get the length from the binary's file (may be costly)", (Object)blobInfo.key);
            File file = binary.getFile();
            length = file == null ? -1L : file.length();
        }
        BinaryBlob blob = new BinaryBlob(binary, blobInfo.key, blobInfo.filename, blobInfo.mimeType, blobInfo.encoding, null, blobInfo.digest, length);
        this.fixupDigest(blob, digest);
        return blob;
    }

    @Override
    public File getFile(ManagedBlob blob) {
        String key = this.stripBlobKeyPrefix(blob.getKey());
        Binary binary = this.binaryManager.getBinary(key);
        if (binary == null || binary instanceof LazyBinary) {
            return null;
        }
        return binary.getFile();
    }

    @Override
    public String writeBlob(Blob blob) throws IOException {
        String digest = this.binaryManager.getBinary(blob).getDigest();
        this.fixupDigest(blob, digest);
        return digest;
    }

    protected void fixupDigest(Blob blob, String digest) {
        if (this.binaryManager instanceof AbstractBinaryManager) {
            AbstractBinaryManager bm = (AbstractBinaryManager)this.binaryManager;
            String currentDigest = blob.getDigest();
            if (currentDigest == null || currentDigest.contains("-")) {
                blob.setDigest(digest);
                currentDigest = digest;
            }
            if (blob.getDigestAlgorithm() == null && bm.isValidDigest(currentDigest)) {
                blob.setDigestAlgorithm(bm.getDigestAlgorithm());
            }
        }
    }

    @Override
    public Map<String, String> getProperties() {
        return Collections.emptyMap();
    }
}

