/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.automation.OperationParameters;

public class OperationChain
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LogManager.getLogger(OperationChain.class);
    protected final String id;
    protected final transient List<OperationParameters> operations = new ArrayList<OperationParameters>();
    protected final transient Map<String, Object> chainParameters = new HashMap<String, Object>();
    protected String description;
    protected String[] aliases;
    protected boolean isPublic;
    protected boolean enabled;

    public OperationChain(String id) {
        this(id, Collections.emptyList());
    }

    public OperationChain(String id, List<OperationParameters> operations) {
        this(id, operations, Collections.emptyMap());
    }

    public OperationChain(String id, List<OperationParameters> operations, Map<String, Object> chainParameters) {
        this.id = id;
        this.operations.addAll(operations);
        this.chainParameters.putAll(chainParameters);
    }

    public String getId() {
        return this.id;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setAliases(String[] aliases) {
        this.aliases = aliases;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    public List<OperationParameters> getOperations() {
        return this.operations;
    }

    public void add(OperationParameters op) {
        this.operations.add(op);
    }

    public OperationParameters add(String operationId) {
        OperationParameters op = new OperationParameters(operationId);
        this.operations.add(op);
        return op;
    }

    public void addChainParameters(Map<String, Object> chainParameter) {
        if (chainParameter == null) {
            log.warn("null parameters given to " + this.id, new Throwable("stack trace"));
            return;
        }
        this.chainParameters.putAll(chainParameter);
    }

    public Map<String, Object> getChainParameters() {
        return this.chainParameters;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id.hashCode();
        result = 31 * result + this.chainParameters.hashCode();
        result = 31 * result + this.operations.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OperationChain)) {
            return false;
        }
        OperationChain other = (OperationChain)obj;
        if (!this.id.equals(other.id)) {
            return false;
        }
        if (!this.chainParameters.equals(other.chainParameters)) {
            return false;
        }
        return this.operations.equals(other.operations);
    }

    public String toString() {
        return "OperationChain [id=" + this.id + "]";
    }

    public OperationChain clone() {
        OperationChain clone = new OperationChain(this.id, this.operations, this.chainParameters);
        clone.enabled = this.enabled;
        clone.description = this.description;
        if (this.aliases != null) {
            clone.aliases = Arrays.copyOf(this.aliases, this.aliases.length);
        }
        clone.isPublic = this.isPublic;
        return clone;
    }

    public void merge(OperationChain other) {
        this.enabled = other.enabled;
        this.operations.clear();
        this.operations.addAll(other.operations);
        this.chainParameters.clear();
        this.chainParameters.putAll(other.chainParameters);
        this.description = other.description;
        this.aliases = other.aliases;
        this.isPublic = other.isPublic;
    }
}

