/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.context;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.automation.context.ContextHelper;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.runtime.model.Descriptor;

@XObject(value="contextHelper")
public class ContextHelperDescriptor
implements Descriptor {
    private static final Logger log = LogManager.getLogger(ContextHelperDescriptor.class);
    @XNode(value="@id")
    protected String id;
    @XNode(value="@class")
    protected Class<? extends ContextHelper> contextHelperClass;
    @XNode(value="@enabled")
    protected boolean enabled = true;

    public String getId() {
        return this.id;
    }

    public ContextHelper instantiateContextHelper() {
        try {
            return this.contextHelperClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new NuxeoException("Unable to instantiate the context helper: " + this.id, (Throwable)e);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Descriptor merge(Descriptor o) {
        ContextHelperDescriptor other = (ContextHelperDescriptor)o;
        log.warn("The context helper: {} with id: {} is overriding the helper: {}", other.contextHelperClass, (Object)this.id, this.contextHelperClass);
        return other;
    }
}

