/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core;

import org.apache.commons.lang3.StringUtils;
import org.nuxeo.common.xmap.annotation.XContext;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.core.OperationDescriptor;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.impl.OperationTypeImpl;
import org.nuxeo.runtime.model.ComponentInstance;

@XObject(value="operation")
public class OperationContribution
implements OperationDescriptor {
    @XNode(value="@class")
    public String type;
    @XNode(value="@replace")
    public boolean replace;
    @XContext(value="contributingComponent")
    protected ComponentInstance contributingComponent;

    public String getId() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.getOperationAnnotation().id(), (CharSequence)this.type);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean replace() {
        return this.replace;
    }

    @Override
    public OperationType toType() {
        return new OperationTypeImpl(this.getId(), this.getTypeClass(), this.contributingComponent.getName().getRawName());
    }

    protected Operation getOperationAnnotation() {
        Class<?> typeClass = this.getTypeClass();
        Operation annotation = typeClass.getAnnotation(Operation.class);
        if (annotation == null) {
            throw new IllegalArgumentException("Invalid operation class: " + this.type + ". No @Operation annotation found on class.");
        }
        return annotation;
    }

    protected Class<?> getTypeClass() {
        try {
            return Class.forName(this.type);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Invalid operation class: " + this.type + ". Class is not found.");
        }
    }
}

