/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.events;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.events.EventHandler;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.runtime.api.Framework;

public class EventHandlerRegistry {
    private static final Logger log = LogManager.getLogger(EventHandlerRegistry.class);
    protected final Map<String, List<EventHandler>> handlers;
    protected final Map<String, List<EventHandler>> postCommitHandlers;

    public EventHandlerRegistry(Map<String, List<EventHandler>> handlers, Map<String, List<EventHandler>> postCommitHandlers) {
        this.handlers = handlers;
        this.postCommitHandlers = postCommitHandlers;
    }

    public List<EventHandler> getEventHandlers(String eventId) {
        return this.handlers.get(eventId);
    }

    public List<EventHandler> getPostCommitEventHandlers(String eventId) {
        return this.postCommitHandlers.get(eventId);
    }

    public Set<String> getPostCommitEventNames() {
        return this.postCommitHandlers.keySet();
    }

    public boolean acceptEvent(Event event, List<EventHandler> handlers) {
        if (CollectionUtils.isEmpty(handlers)) {
            return false;
        }
        EventContext eventContext = event.getContext();
        try (OperationContext ctx = this.getOperationContext(eventContext);){
            ctx.put("Event", (Object)event);
            boolean bl = handlers.stream().anyMatch(handler -> handler.isEnabled(ctx, eventContext, true));
            return bl;
        }
    }

    public void handleEvent(Event event, List<EventHandler> handlers, boolean saveSession) {
        if (handlers == null || handlers.isEmpty()) {
            return;
        }
        EventContext eventContext = event.getContext();
        for (EventHandler handler : handlers) {
            try {
                OperationContext ctx = this.getOperationContext(eventContext);
                try {
                    ctx.put("Event", (Object)event);
                    ctx.setCommit(saveSession);
                    if (!handler.isEnabled(ctx, eventContext, false)) continue;
                    ((AutomationService)Framework.getService(AutomationService.class)).run(ctx, handler.getChainId());
                }
                finally {
                    if (ctx == null) continue;
                    ctx.close();
                }
            }
            catch (OperationException e) {
                log.error("Failed to handle event: {} using chain: {}", (Object)event.getName(), (Object)handler.getChainId(), (Object)e);
                throw new NuxeoException((Throwable)e);
            }
            catch (NuxeoException e) {
                log.error("Failed to handle event: {} using chain: {}", (Object)event.getName(), (Object)handler.getChainId(), (Object)e);
                throw e;
            }
        }
    }

    protected OperationContext getOperationContext(EventContext eventContext) {
        if (eventContext instanceof DocumentEventContext) {
            DocumentEventContext documentEventContext = (DocumentEventContext)eventContext;
            OperationContext ctx = new OperationContext(eventContext.getCoreSession());
            ctx.setInput(documentEventContext.getSourceDocument());
            return ctx;
        }
        return new OperationContext();
    }
}

