/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.events.operations;

import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.stream.Collectors;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.event.impl.EventContextImpl;

@Operation(id="Event.Fire", category="Notification", label="Send Event", description="Send a Nuxeo event.", aliases={"Notification.SendEvent"})
public class FireEvent {
    public static final String ID = "Event.Fire";
    @Context
    protected OperationContext ctx;
    @Context
    protected EventProducer service;
    @Param(name="name")
    protected String name;
    @Param(name="properties", required=false)
    protected Properties properties = new Properties();

    @OperationMethod
    public void run() {
        Object input;
        CoreSession session = this.ctx.getCoreSession();
        Object object = input = this.ctx.getInput();
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DocumentRef.class, DocumentModel.class, DocumentModelList.class}, (Object)object, n)) {
            case 0: {
                DocumentRef docRef = (DocumentRef)object;
                this.sendDocumentEvent(session.getDocument(docRef));
                break;
            }
            case 1: {
                DocumentModel doc = (DocumentModel)object;
                this.sendDocumentEvent(doc);
                break;
            }
            case 2: {
                DocumentModelList docs = (DocumentModelList)object;
                docs.forEach(this::sendDocumentEvent);
                break;
            }
            default: {
                this.sendUnknownEvent(input);
            }
        }
    }

    protected void sendDocumentEvent(DocumentModel input) {
        CoreSession session = this.ctx.getCoreSession();
        this.sendEvent((EventContext)new DocumentEventContext(session, session.getPrincipal(), input));
    }

    protected void sendUnknownEvent(Object input) {
        CoreSession session = this.ctx.getCoreSession();
        this.sendEvent((EventContext)new EventContextImpl(session, session.getPrincipal(), new Object[]{input}));
    }

    protected void sendEvent(EventContext eventContext) {
        Event event = eventContext.newEvent(this.name);
        event.getContext().setProperties(this.properties.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        this.service.fireEvent(event);
    }
}

