/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.impl;

import java.lang.invoke.CallSite;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.core.impl.InvokableMethod;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentRefList;

public abstract class AbstractOperationType
implements OperationType {
    protected List<String> buildSignature(List<InvokableMethod> methods, Function<InvokableMethod, Class<?>> outputTypeGetter) {
        HashSet<CallSite> collectedSigs = new HashSet<CallSite>();
        ArrayList<String> signature = new ArrayList<String>(methods.size() * 2);
        for (InvokableMethod method : methods) {
            String output;
            String input = this.getParamDocumentationType(method.getInputType(), method.isIterable());
            String sigKey = input + ":" + (output = this.getParamDocumentationType(outputTypeGetter.apply(method)));
            if (collectedSigs.contains(sigKey)) continue;
            signature.add(input);
            signature.add(output);
            collectedSigs.add((CallSite)((Object)sigKey));
        }
        return signature;
    }

    protected String getParamDocumentationType(Class<?> type) {
        return this.getParamDocumentationType(type, false);
    }

    protected String getParamDocumentationType(Class<?> type, boolean isIterable) {
        String t = DocumentModel.class.isAssignableFrom(type) || DocumentRef.class.isAssignableFrom(type) ? (isIterable ? "documents" : "document") : (DocumentModelList.class.isAssignableFrom(type) || DocumentRefList.class.isAssignableFrom(type) ? "documents" : (BlobList.class.isAssignableFrom(type) ? "bloblist" : (Blob.class.isAssignableFrom(type) ? (isIterable ? "bloblist" : "blob") : (URL.class.isAssignableFrom(type) ? "resource" : (Calendar.class.isAssignableFrom(type) ? "date" : type.getSimpleName().toLowerCase())))));
        return t;
    }
}

