/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.impl;

import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuxeo.common.function.ThrowableFunction;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationDocumentation;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.core.OperationChainContribution;
import org.nuxeo.ecm.automation.core.impl.AbstractOperationType;
import org.nuxeo.ecm.automation.core.impl.InvokableMethod;
import org.nuxeo.ecm.automation.core.impl.OperationChainCompiler;
import org.nuxeo.runtime.api.Framework;

public class ChainTypeImpl
extends AbstractOperationType {
    protected static final Method runMethod;
    protected OperationChain chain;
    protected InvokableMethod[] methods = new InvokableMethod[]{new InvokableMethod(this, runMethod)};
    protected String contributingComponent;
    protected OperationChainContribution contribution;

    public ChainTypeImpl(OperationChain chain, OperationChainContribution contribution, String contributingComponent) {
        this.contribution = contribution;
        this.chain = chain;
        this.contributingComponent = contributingComponent;
    }

    @Override
    public String getId() {
        return this.chain.getId();
    }

    @Override
    public String[] getAliases() {
        return this.chain.getAliases();
    }

    @Override
    public boolean isEnabled() {
        return this.chain.isEnabled();
    }

    @Override
    public Class<?> getType() {
        return OperationChainCompiler.CompiledChainImpl.class;
    }

    @Override
    public OperationDocumentation getDocumentation() throws OperationException {
        OperationDocumentation doc = new OperationDocumentation(this.chain.getId());
        doc.label = this.chain.getId();
        doc.requires = this.contribution.getRequires();
        doc.category = this.contribution.getCategory();
        doc.setAliases(this.contribution.getAliases());
        OperationChainContribution.Operation[] operations = this.contribution.getOps();
        doc.operations = operations;
        doc.since = this.contribution.getSince();
        if (doc.requires.isEmpty()) {
            doc.requires = null;
        }
        if (doc.label.isEmpty()) {
            doc.label = doc.id;
        }
        doc.description = this.contribution.getDescription();
        doc.params = this.contribution.getParams();
        if (operations.length != 0) {
            List<String> result = this.getSignature(operations);
            doc.signature = (String[])result.toArray(String[]::new);
        } else {
            doc.signature = new String[]{"void", "void"};
        }
        return doc;
    }

    protected List<String> getSignature(OperationChainContribution.Operation[] operations) throws OperationException {
        OperationType operationType = ((AutomationService)Framework.getService(AutomationService.class)).getOperation(operations[0].getId());
        return this.buildSignature(operationType.getMethods(), ThrowableFunction.asFunction(method -> this.getChainOutput(method.getInputType(), operations)));
    }

    protected Class<?> getChainOutput(Class<?> chainInput, OperationChainContribution.Operation[] operations) throws OperationException {
        for (OperationChainContribution.Operation operation : operations) {
            OperationType operationType = ((AutomationService)Framework.getService(AutomationService.class)).getOperation(operation.getId());
            chainInput = operationType instanceof ChainTypeImpl ? this.getChainOutput(chainInput, operationType.getDocumentation().getOperations()) : this.getOperationOutput(chainInput, operationType);
        }
        return chainInput;
    }

    protected Class<?> getOperationOutput(Class<?> input, OperationType operationType) {
        InvokableMethod[] methodsMatchingInput = operationType.getMethodsMatchingInput(input);
        if (methodsMatchingInput.length == 0) {
            return input;
        }
        InvokableMethod topMethod = Stream.of(methodsMatchingInput).max(Comparator.comparingInt(InvokableMethod::getPriority)).orElseThrow();
        Class<?> nextInput = topMethod.getOutputType();
        if (nextInput == Void.TYPE) {
            return input;
        }
        return nextInput;
    }

    @Override
    public String getContributingComponent() {
        return this.contributingComponent;
    }

    @Override
    public InvokableMethod[] getMethodsMatchingInput(Class<?> in) {
        return this.methods;
    }

    @Override
    public List<InvokableMethod> getMethods() {
        return List.of(this.methods);
    }

    @Override
    public Object newInstance(OperationContext ctx, Map<String, Object> args) throws OperationException {
        Object input = ctx.getInput();
        Class<Void> inputType = input == null ? Void.TYPE : input.getClass();
        return ((AutomationService)Framework.getService(AutomationService.class)).compileChain(inputType, this.chain);
    }

    public OperationChain getChain() {
        return this.chain;
    }

    public Map<String, Object> getChainParameters() {
        return this.chain.getChainParameters();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.chain == null ? 0 : this.chain.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ChainTypeImpl)) {
            return false;
        }
        ChainTypeImpl other = (ChainTypeImpl)obj;
        return Objects.equals(this.chain, other.chain);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.getId()).toString();
    }

    static {
        try {
            runMethod = OperationChainCompiler.CompiledChainImpl.class.getMethod("invoke", OperationContext.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new UnsupportedOperationException("Cannot use reflection for run method", e);
        }
    }
}

