/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.mail;

import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.BodyPart;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMultipart;
import jakarta.validation.constraints.NotNull;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.Environment;
import org.nuxeo.ecm.automation.core.mail.Mailer;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.platform.rendering.api.RenderingException;
import org.nuxeo.ecm.platform.rendering.api.ResourceLocator;
import org.nuxeo.ecm.platform.rendering.fm.FreemarkerEngine;
import org.nuxeo.mail.BlobDataSource;
import org.nuxeo.runtime.api.Framework;

@Deprecated(since="2023.4")
public class Composer {
    private static final Logger log = LogManager.getLogger(Composer.class);
    protected static final Properties MAIL_PROPERTIES = new Properties();
    protected final FreemarkerEngine engine;
    protected Mailer mailer;
    protected final ConcurrentMap<String, URL> urls = new ConcurrentHashMap<String, URL>();

    public Composer() {
        this(null);
    }

    public Composer(Mailer mailer) {
        this.mailer = mailer == null ? this.createMailer() : mailer;
        this.engine = new FreemarkerEngine();
        this.engine.setResourceLocator(new ResourceLocator(){

            public URL getResourceURL(String key) {
                return (URL)Composer.this.urls.get(key);
            }

            public File getResourceFile(String key) {
                return null;
            }
        });
    }

    protected Mailer createMailer() {
        Properties properties = Composer.getMailProperties();
        if (!properties.isEmpty()) {
            this.mailer = new Mailer(properties);
        }
        if (this.mailer == null) {
            String name = Framework.getProperty((String)"jndi.java.mail", (String)"java:comp/env/Mail");
            this.mailer = new Mailer(name);
        }
        return this.mailer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected static Properties getMailProperties() {
        File mailFile = Composer.getMailPropertiesFile();
        if (mailFile != null && MAIL_PROPERTIES.isEmpty() || Framework.isTestModeSet()) {
            Properties properties = MAIL_PROPERTIES;
            synchronized (properties) {
                if (mailFile != null && MAIL_PROPERTIES.isEmpty() || Framework.isTestModeSet()) {
                    MAIL_PROPERTIES.clear();
                    if (mailFile != null) {
                        try (FileInputStream in = new FileInputStream(mailFile);){
                            MAIL_PROPERTIES.load(in);
                        }
                        catch (IOException e) {
                            log.error("Failed to load mail properties", (Throwable)e);
                        }
                    }
                }
            }
        }
        return MAIL_PROPERTIES;
    }

    protected static File getMailPropertiesFile() {
        File file;
        Environment env = Environment.getDefault();
        if (env != null && (file = new File(env.getConfig(), "mail.properties")).isFile()) {
            log.warn("mail properties should be directly placed in nuxeo.conf or in a MailSender contribution");
            return file;
        }
        return null;
    }

    public void registerTemplate(URL url) {
        this.urls.put(url.toExternalForm(), url);
    }

    public void unregisterTemplate(URL url) {
        this.urls.remove(url.toExternalForm());
    }

    public void unregisterAllTemplates() {
        this.urls.clear();
    }

    public Mailer getMailer() {
        return this.mailer;
    }

    public FreemarkerEngine getEngine() {
        return this.engine;
    }

    public void render(String template, Object ctx, Writer writer) throws RenderingException {
        this.engine.render(template, ctx, writer);
    }

    public void render(URL template, Object ctx, Writer writer) throws RenderingException {
        String key = template.toExternalForm();
        this.urls.putIfAbsent(key, template);
        this.engine.render(key, ctx, writer);
    }

    public String render(URL template, Object ctx) throws RenderingException {
        String key = template.toExternalForm();
        this.urls.putIfAbsent(key, template);
        StringWriter writer = new StringWriter();
        this.engine.render(key, ctx, (Writer)writer);
        return writer.toString();
    }

    public String render(String templateContent, Object ctx) throws TemplateException, IOException {
        StringReader reader = new StringReader(templateContent);
        Template temp = new Template("@inline", (Reader)reader, this.engine.getConfiguration(), "UTF-8");
        StringWriter writer = new StringWriter();
        freemarker.core.Environment env = temp.createProcessingEnvironment(ctx, (Writer)writer, (ObjectWrapper)this.engine.getObjectWrapper());
        env.process();
        return writer.toString();
    }

    public Mailer.Message newMessage() {
        return this.mailer.newMessage();
    }

    public Mailer.Message newTextMessage(URL template, Object ctx) throws RenderingException, MessagingException {
        Mailer.Message msg = this.mailer.newMessage();
        msg.setText(this.render(template, ctx), "UTF-8");
        return msg;
    }

    public Mailer.Message newTextMessage(String templateContent, Object ctx) throws RenderingException, MessagingException, TemplateException, IOException {
        Mailer.Message msg = this.mailer.newMessage();
        msg.setText(this.render(templateContent, ctx), "UTF-8");
        return msg;
    }

    public Mailer.Message newHtmlMessage(URL template, Object ctx) throws RenderingException, MessagingException {
        Mailer.Message msg = this.mailer.newMessage();
        msg.setContent(this.render(template, ctx), "text/html; charset=utf-8");
        return msg;
    }

    public Mailer.Message newHtmlMessage(String templateContent, Object ctx) throws MessagingException, TemplateException, IOException {
        Mailer.Message msg = this.mailer.newMessage();
        msg.setContent(this.render(templateContent, ctx), "text/html; charset=utf-8");
        return msg;
    }

    public Mailer.Message newMixedMessage(String templateContent, Object ctx, String textType, List<Blob> attachments) throws TemplateException, IOException, MessagingException {
        if (textType == null) {
            textType = "plain";
        }
        Mailer.Message msg = this.mailer.newMessage();
        MimeMultipart mp = new MimeMultipart();
        MimeBodyPart body = new MimeBodyPart();
        String result = this.render(templateContent, ctx);
        body.setText(result, "UTF-8", textType);
        mp.addBodyPart((BodyPart)body);
        for (Blob blob : attachments) {
            MimeBodyPart a = new MimeBodyPart();
            a.setDataHandler(new DataHandler((DataSource)new BlobDataSource(blob)));
            a.setFileName(blob.getFilename());
            mp.addBodyPart((BodyPart)a);
        }
        msg.setContent((Multipart)mp);
        return msg;
    }
}

