/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.blob;

import java.io.IOException;
import java.util.List;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.utils.BlobUtils;

@Operation(id="Blob.CreateZip", category="Files", label="Zip", description="Creates a zip file from the input file(s). If no file name is given, the first file name in the input will be used. Returns the zip file.")
public class CreateZip {
    public static final String ID = "Blob.CreateZip";
    @Param(name="filename", required=false)
    protected String fileName;

    @OperationMethod
    public Blob run(Blob blob) throws IOException {
        return BlobUtils.zip((Blob)blob, (String)this.fileName);
    }

    @OperationMethod
    public Blob run(BlobList blobs) throws IOException {
        return BlobUtils.zip((List)blobs, (String)this.fileName);
    }
}

