/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.blob;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionService;

@Operation(id="Blob.RunConverter", category="Conversion", label="Blob.RunConverter", description="Simply call a converter based on the 'converter' parameter. You can pass the converter properties with the 'properties' parameter.", since="7.1")
public class RunConverter {
    private static final Logger log = LogManager.getLogger(RunConverter.class);
    public static final String ID = "Blob.RunConverter";
    @Param(name="converter", description="The name of the converter to call")
    protected String converter;
    @Param(name="parameters", description="The converter parameters to pass", required=false)
    protected Properties parameters;
    @Context
    protected ConversionService conversionService;

    @OperationMethod
    public Blob run(Blob blob) {
        log.debug("Call converter named: {}", (Object)this.converter);
        BlobHolder holder = this.conversionService.convert(this.converter, (BlobHolder)new SimpleBlobHolder(blob), this.propertiesToMap());
        return holder.getBlob();
    }

    private Map<String, Serializable> propertiesToMap() {
        if (this.parameters == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Serializable> params = new HashMap<String, Serializable>(this.parameters.size());
        for (Map.Entry entry : this.parameters.entrySet()) {
            params.put((String)entry.getKey(), (Serializable)entry.getValue());
        }
        return params;
    }
}

