/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.document;

import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;

@Operation(id="Document.CopySchema", category="Document", label="Copy Schema", description="Copy all the properties from the schema of the source into the input document. Either sourceId or sourcePath parameter should be filled. When both are filled, sourceId will be used. If saveDocument is true, the document is saved. If save is true, the session is saved (setting save to true and saveDocument to false has no effect, the session will not be saved)")
public class CopySchema {
    public static final String ID = "Document.CopySchema";
    @Context
    protected OperationContext context;
    @Context
    protected CoreSession session;
    @Param(name="schema")
    protected String schema;
    @Param(name="sourceId", required=false)
    protected String sourceId;
    @Param(name="sourcePath", required=false)
    protected String sourcePath;
    @Param(name="save", required=false, values={"true"})
    protected boolean save = true;
    @Param(name="saveDocument", required=false, values={"true"})
    protected boolean saveDocument = true;

    private DocumentModel getDocumentFromIdOrPath() throws OperationException {
        if (this.sourceId != null) {
            return this.session.getDocument((DocumentRef)new IdRef(this.sourceId));
        }
        if (this.sourcePath != null) {
            return this.session.getDocument((DocumentRef)new PathRef(this.sourcePath));
        }
        throw new OperationException("No document id or path was provided");
    }

    private void copySchemaProperties(DocumentModel source, DocumentModel target) {
        target.setProperties(this.schema, source.getProperties(this.schema));
    }

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel target) throws OperationException {
        DocumentModel source = this.getDocumentFromIdOrPath();
        this.copySchemaProperties(source, target);
        if (this.saveDocument) {
            target = this.session.saveDocument(target);
            if (this.save) {
                this.session.save();
            }
        }
        return target;
    }
}

