/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.document;

import java.util.HashMap;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Document.PublishToSection", category="Document", label="Publish Document", description="Publish the input document into the target section. Existing proxy is overrided if the override attribute is set. Return the created proxy.", aliases={"Document.Publish"})
public class PublishDocument {
    public static final String ID = "Document.PublishToSection";
    @Context
    protected CoreSession session;
    @Param(name="target")
    protected DocumentModel target;
    @Param(name="override", required=false, values={"true"})
    protected boolean override = true;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) {
        DocumentModel proxy = this.session.publishDocument(doc, this.target, this.override);
        this.notifyPublishedEvent(doc);
        this.notifyPublishedEvent(proxy);
        return proxy;
    }

    protected void notifyPublishedEvent(DocumentModel doc) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("repositoryName", doc.getRepositoryName());
        properties.put("documentLifeCycle", doc.getCurrentLifeCycleState());
        DocumentEventContext ctx = new DocumentEventContext(this.session, this.session.getPrincipal(), doc);
        ctx.setProperties(properties);
        ctx.setCategory("eventDocumentCategory");
        Event event = ctx.newEvent("documentPublished");
        ((EventProducer)Framework.getService(EventProducer.class)).fireEvent(event);
    }
}

