/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.document;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;

@Operation(id="Document.UnblockPermissionInheritance", category="Document", label="Unblock Permission Inheritance", description="Unblock the permission inheritance on the input document(s). Returns the document(s).")
public class UnblockPermissionInheritance {
    public static final String ID = "Document.UnblockPermissionInheritance";
    @Context
    protected CoreSession session;
    @Param(name="acl", required=false, values={"local"}, description="ACL name.")
    String aclName = "local";

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) {
        this.unblockPermissionInheritance(doc);
        return this.session.getDocument(doc.getRef());
    }

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentRef docRef) {
        DocumentModel doc = this.session.getDocument(docRef);
        this.unblockPermissionInheritance(doc);
        return doc;
    }

    protected void unblockPermissionInheritance(DocumentModel doc) {
        Object acp = doc.getACP() != null ? doc.getACP() : new ACPImpl();
        boolean permissionChanged = acp.unblockInheritance(this.aclName);
        if (permissionChanged) {
            doc.setACP(acp, true);
        }
    }
}

